/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.services.budgets.transform.NotificationWithSubscribersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationWithSubscribers
implements StructuredPojo,
ToCopyableBuilder<Builder, NotificationWithSubscribers> {
    private final Notification notification;
    private final List<Subscriber> subscribers;

    private NotificationWithSubscribers(BuilderImpl builder) {
        this.notification = builder.notification;
        this.subscribers = builder.subscribers;
    }

    public Notification notification() {
        return this.notification;
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationWithSubscribers)) {
            return false;
        }
        NotificationWithSubscribers other = (NotificationWithSubscribers)obj;
        return Objects.equals(this.notification(), other.notification()) && Objects.equals(this.subscribers(), other.subscribers());
    }

    public String toString() {
        return ToString.builder((String)"NotificationWithSubscribers").add("Notification", (Object)this.notification()).add("Subscribers", this.subscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Notification": {
                return Optional.of(clazz.cast(this.notification()));
            }
            case "Subscribers": {
                return Optional.of(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationWithSubscribersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Notification notification;
        private List<Subscriber> subscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationWithSubscribers model) {
            this.notification(model.notification);
            this.subscribers(model.subscribers);
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return this.subscribers != null ? (Collection)this.subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        public NotificationWithSubscribers build() {
            return new NotificationWithSubscribers(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationWithSubscribers> {
        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().apply(notification)).build());
        }

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);
    }
}

