/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeBudgetRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();
    private static final DescribeBudgetRequestModelMarshaller INSTANCE = new DescribeBudgetRequestModelMarshaller();

    private DescribeBudgetRequestModelMarshaller() {
    }

    public static DescribeBudgetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeBudgetRequest describeBudgetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeBudgetRequest), (String)"describeBudgetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeBudgetRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)describeBudgetRequest.budgetName(), BUDGETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

