/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationMarshaller {
    private static final MarshallingInfo<String> NOTIFICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationType").isBinary(false).build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").isBinary(false).build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Threshold").isBinary(false).build();
    private static final MarshallingInfo<String> THRESHOLDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThresholdType").isBinary(false).build();
    private static final NotificationMarshaller INSTANCE = new NotificationMarshaller();

    private NotificationMarshaller() {
    }

    public static NotificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Notification notification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notification, (String)"notification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notification.notificationTypeAsString(), NOTIFICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)notification.comparisonOperatorAsString(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)notification.threshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)notification.thresholdTypeAsString(), THRESHOLDTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

