/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.CostTypesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The types of cost included in a budget, such as tax and subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostTypes implements StructuredPojo, ToCopyableBuilder<CostTypes.Builder, CostTypes> {
    private final Boolean includeTax;

    private final Boolean includeSubscription;

    private final Boolean useBlended;

    private final Boolean includeRefund;

    private final Boolean includeCredit;

    private final Boolean includeUpfront;

    private final Boolean includeRecurring;

    private final Boolean includeOtherSubscription;

    private final Boolean includeSupport;

    private final Boolean includeDiscount;

    private final Boolean useAmortized;

    private CostTypes(BuilderImpl builder) {
        this.includeTax = builder.includeTax;
        this.includeSubscription = builder.includeSubscription;
        this.useBlended = builder.useBlended;
        this.includeRefund = builder.includeRefund;
        this.includeCredit = builder.includeCredit;
        this.includeUpfront = builder.includeUpfront;
        this.includeRecurring = builder.includeRecurring;
        this.includeOtherSubscription = builder.includeOtherSubscription;
        this.includeSupport = builder.includeSupport;
        this.includeDiscount = builder.includeDiscount;
        this.useAmortized = builder.useAmortized;
    }

    /**
     * <p>
     * Specifies whether a budget includes taxes.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes taxes.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeTax() {
        return includeTax;
    }

    /**
     * <p>
     * Specifies whether a budget includes subscriptions.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes subscriptions.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeSubscription() {
        return includeSubscription;
    }

    /**
     * <p>
     * Specifies whether a budget uses blended rate.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether a budget uses blended rate.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public Boolean useBlended() {
        return useBlended;
    }

    /**
     * <p>
     * Specifies whether a budget includes refunds.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes refunds.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeRefund() {
        return includeRefund;
    }

    /**
     * <p>
     * Specifies whether a budget includes credits.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes credits.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeCredit() {
        return includeCredit;
    }

    /**
     * <p>
     * Specifies whether a budget includes upfront RI costs.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes upfront RI costs.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeUpfront() {
        return includeUpfront;
    }

    /**
     * <p>
     * Specifies whether a budget includes recurring fees such as monthly RI fees.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeRecurring() {
        return includeRecurring;
    }

    /**
     * <p>
     * Specifies whether a budget includes non-RI subscription costs.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes non-RI subscription costs.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeOtherSubscription() {
        return includeOtherSubscription;
    }

    /**
     * <p>
     * Specifies whether a budget includes support subscription fees.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes support subscription fees.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeSupport() {
        return includeSupport;
    }

    /**
     * <p>
     * Specifies whether a budget includes discounts.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes discounts.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public Boolean includeDiscount() {
        return includeDiscount;
    }

    /**
     * <p>
     * Specifies whether a budget uses the amortized rate.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether a budget uses the amortized rate.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public Boolean useAmortized() {
        return useAmortized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeTax());
        hashCode = 31 * hashCode + Objects.hashCode(includeSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(useBlended());
        hashCode = 31 * hashCode + Objects.hashCode(includeRefund());
        hashCode = 31 * hashCode + Objects.hashCode(includeCredit());
        hashCode = 31 * hashCode + Objects.hashCode(includeUpfront());
        hashCode = 31 * hashCode + Objects.hashCode(includeRecurring());
        hashCode = 31 * hashCode + Objects.hashCode(includeOtherSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(includeSupport());
        hashCode = 31 * hashCode + Objects.hashCode(includeDiscount());
        hashCode = 31 * hashCode + Objects.hashCode(useAmortized());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostTypes)) {
            return false;
        }
        CostTypes other = (CostTypes) obj;
        return Objects.equals(includeTax(), other.includeTax())
                && Objects.equals(includeSubscription(), other.includeSubscription())
                && Objects.equals(useBlended(), other.useBlended()) && Objects.equals(includeRefund(), other.includeRefund())
                && Objects.equals(includeCredit(), other.includeCredit())
                && Objects.equals(includeUpfront(), other.includeUpfront())
                && Objects.equals(includeRecurring(), other.includeRecurring())
                && Objects.equals(includeOtherSubscription(), other.includeOtherSubscription())
                && Objects.equals(includeSupport(), other.includeSupport())
                && Objects.equals(includeDiscount(), other.includeDiscount())
                && Objects.equals(useAmortized(), other.useAmortized());
    }

    @Override
    public String toString() {
        return ToString.builder("CostTypes").add("IncludeTax", includeTax()).add("IncludeSubscription", includeSubscription())
                .add("UseBlended", useBlended()).add("IncludeRefund", includeRefund()).add("IncludeCredit", includeCredit())
                .add("IncludeUpfront", includeUpfront()).add("IncludeRecurring", includeRecurring())
                .add("IncludeOtherSubscription", includeOtherSubscription()).add("IncludeSupport", includeSupport())
                .add("IncludeDiscount", includeDiscount()).add("UseAmortized", useAmortized()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeTax":
            return Optional.ofNullable(clazz.cast(includeTax()));
        case "IncludeSubscription":
            return Optional.ofNullable(clazz.cast(includeSubscription()));
        case "UseBlended":
            return Optional.ofNullable(clazz.cast(useBlended()));
        case "IncludeRefund":
            return Optional.ofNullable(clazz.cast(includeRefund()));
        case "IncludeCredit":
            return Optional.ofNullable(clazz.cast(includeCredit()));
        case "IncludeUpfront":
            return Optional.ofNullable(clazz.cast(includeUpfront()));
        case "IncludeRecurring":
            return Optional.ofNullable(clazz.cast(includeRecurring()));
        case "IncludeOtherSubscription":
            return Optional.ofNullable(clazz.cast(includeOtherSubscription()));
        case "IncludeSupport":
            return Optional.ofNullable(clazz.cast(includeSupport()));
        case "IncludeDiscount":
            return Optional.ofNullable(clazz.cast(includeDiscount()));
        case "UseAmortized":
            return Optional.ofNullable(clazz.cast(useAmortized()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostTypesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CostTypes> {
        /**
         * <p>
         * Specifies whether a budget includes taxes.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeTax
         *        Specifies whether a budget includes taxes.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTax(Boolean includeTax);

        /**
         * <p>
         * Specifies whether a budget includes subscriptions.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeSubscription
         *        Specifies whether a budget includes subscriptions.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSubscription(Boolean includeSubscription);

        /**
         * <p>
         * Specifies whether a budget uses blended rate.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param useBlended
         *        Specifies whether a budget uses blended rate.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBlended(Boolean useBlended);

        /**
         * <p>
         * Specifies whether a budget includes refunds.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeRefund
         *        Specifies whether a budget includes refunds.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRefund(Boolean includeRefund);

        /**
         * <p>
         * Specifies whether a budget includes credits.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeCredit
         *        Specifies whether a budget includes credits.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCredit(Boolean includeCredit);

        /**
         * <p>
         * Specifies whether a budget includes upfront RI costs.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeUpfront
         *        Specifies whether a budget includes upfront RI costs.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeUpfront(Boolean includeUpfront);

        /**
         * <p>
         * Specifies whether a budget includes recurring fees such as monthly RI fees.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeRecurring
         *        Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRecurring(Boolean includeRecurring);

        /**
         * <p>
         * Specifies whether a budget includes non-RI subscription costs.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeOtherSubscription
         *        Specifies whether a budget includes non-RI subscription costs.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOtherSubscription(Boolean includeOtherSubscription);

        /**
         * <p>
         * Specifies whether a budget includes support subscription fees.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeSupport
         *        Specifies whether a budget includes support subscription fees.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSupport(Boolean includeSupport);

        /**
         * <p>
         * Specifies whether a budget includes discounts.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeDiscount
         *        Specifies whether a budget includes discounts.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDiscount(Boolean includeDiscount);

        /**
         * <p>
         * Specifies whether a budget uses the amortized rate.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param useAmortized
         *        Specifies whether a budget uses the amortized rate.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAmortized(Boolean useAmortized);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeTax;

        private Boolean includeSubscription;

        private Boolean useBlended;

        private Boolean includeRefund;

        private Boolean includeCredit;

        private Boolean includeUpfront;

        private Boolean includeRecurring;

        private Boolean includeOtherSubscription;

        private Boolean includeSupport;

        private Boolean includeDiscount;

        private Boolean useAmortized;

        private BuilderImpl() {
        }

        private BuilderImpl(CostTypes model) {
            includeTax(model.includeTax);
            includeSubscription(model.includeSubscription);
            useBlended(model.useBlended);
            includeRefund(model.includeRefund);
            includeCredit(model.includeCredit);
            includeUpfront(model.includeUpfront);
            includeRecurring(model.includeRecurring);
            includeOtherSubscription(model.includeOtherSubscription);
            includeSupport(model.includeSupport);
            includeDiscount(model.includeDiscount);
            useAmortized(model.useAmortized);
        }

        public final Boolean getIncludeTax() {
            return includeTax;
        }

        @Override
        public final Builder includeTax(Boolean includeTax) {
            this.includeTax = includeTax;
            return this;
        }

        public final void setIncludeTax(Boolean includeTax) {
            this.includeTax = includeTax;
        }

        public final Boolean getIncludeSubscription() {
            return includeSubscription;
        }

        @Override
        public final Builder includeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
            return this;
        }

        public final void setIncludeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
        }

        public final Boolean getUseBlended() {
            return useBlended;
        }

        @Override
        public final Builder useBlended(Boolean useBlended) {
            this.useBlended = useBlended;
            return this;
        }

        public final void setUseBlended(Boolean useBlended) {
            this.useBlended = useBlended;
        }

        public final Boolean getIncludeRefund() {
            return includeRefund;
        }

        @Override
        public final Builder includeRefund(Boolean includeRefund) {
            this.includeRefund = includeRefund;
            return this;
        }

        public final void setIncludeRefund(Boolean includeRefund) {
            this.includeRefund = includeRefund;
        }

        public final Boolean getIncludeCredit() {
            return includeCredit;
        }

        @Override
        public final Builder includeCredit(Boolean includeCredit) {
            this.includeCredit = includeCredit;
            return this;
        }

        public final void setIncludeCredit(Boolean includeCredit) {
            this.includeCredit = includeCredit;
        }

        public final Boolean getIncludeUpfront() {
            return includeUpfront;
        }

        @Override
        public final Builder includeUpfront(Boolean includeUpfront) {
            this.includeUpfront = includeUpfront;
            return this;
        }

        public final void setIncludeUpfront(Boolean includeUpfront) {
            this.includeUpfront = includeUpfront;
        }

        public final Boolean getIncludeRecurring() {
            return includeRecurring;
        }

        @Override
        public final Builder includeRecurring(Boolean includeRecurring) {
            this.includeRecurring = includeRecurring;
            return this;
        }

        public final void setIncludeRecurring(Boolean includeRecurring) {
            this.includeRecurring = includeRecurring;
        }

        public final Boolean getIncludeOtherSubscription() {
            return includeOtherSubscription;
        }

        @Override
        public final Builder includeOtherSubscription(Boolean includeOtherSubscription) {
            this.includeOtherSubscription = includeOtherSubscription;
            return this;
        }

        public final void setIncludeOtherSubscription(Boolean includeOtherSubscription) {
            this.includeOtherSubscription = includeOtherSubscription;
        }

        public final Boolean getIncludeSupport() {
            return includeSupport;
        }

        @Override
        public final Builder includeSupport(Boolean includeSupport) {
            this.includeSupport = includeSupport;
            return this;
        }

        public final void setIncludeSupport(Boolean includeSupport) {
            this.includeSupport = includeSupport;
        }

        public final Boolean getIncludeDiscount() {
            return includeDiscount;
        }

        @Override
        public final Builder includeDiscount(Boolean includeDiscount) {
            this.includeDiscount = includeDiscount;
            return this;
        }

        public final void setIncludeDiscount(Boolean includeDiscount) {
            this.includeDiscount = includeDiscount;
        }

        public final Boolean getUseAmortized() {
            return useAmortized;
        }

        @Override
        public final Builder useAmortized(Boolean useAmortized) {
            this.useAmortized = useAmortized;
            return this;
        }

        public final void setUseAmortized(Boolean useAmortized) {
            this.useAmortized = useAmortized;
        }

        @Override
        public CostTypes build() {
            return new CostTypes(this);
        }
    }
}
