/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.budgets.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateBudgetResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateBudgetResponseUnmarshaller implements Unmarshaller<UpdateBudgetResponse, JsonUnmarshallerContext> {

    public UpdateBudgetResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateBudgetResponse.Builder updateBudgetResponseBuilder = UpdateBudgetResponse.builder();

        return updateBudgetResponseBuilder.build();
    }

    private static final UpdateBudgetResponseUnmarshaller INSTANCE = new UpdateBudgetResponseUnmarshaller();

    public static UpdateBudgetResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
