/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.CalculatedSpendMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A structure holds the actual and forecasted spend for a budget.
 */
@Generated("software.amazon.awssdk:codegen")
public class CalculatedSpend implements StructuredPojo, ToCopyableBuilder<CalculatedSpend.Builder, CalculatedSpend> {
    private final Spend actualSpend;

    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    /**
     * Returns the value of the ActualSpend property for this object.
     * 
     * @return The value of the ActualSpend property for this object.
     */
    public Spend actualSpend() {
        return actualSpend;
    }

    /**
     * Returns the value of the ForecastedSpend property for this object.
     * 
     * @return The value of the ForecastedSpend property for this object.
     */
    public Spend forecastedSpend() {
        return forecastedSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((actualSpend() == null) ? 0 : actualSpend().hashCode());
        hashCode = 31 * hashCode + ((forecastedSpend() == null) ? 0 : forecastedSpend().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend) obj;
        if (other.actualSpend() == null ^ this.actualSpend() == null) {
            return false;
        }
        if (other.actualSpend() != null && !other.actualSpend().equals(this.actualSpend())) {
            return false;
        }
        if (other.forecastedSpend() == null ^ this.forecastedSpend() == null) {
            return false;
        }
        if (other.forecastedSpend() != null && !other.forecastedSpend().equals(this.forecastedSpend())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (actualSpend() != null) {
            sb.append("ActualSpend: ").append(actualSpend()).append(",");
        }
        if (forecastedSpend() != null) {
            sb.append("ForecastedSpend: ").append(forecastedSpend()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CalculatedSpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CalculatedSpend> {
        /**
         * Sets the value of the ActualSpend property for this object.
         *
         * @param actualSpend
         *        The new value for the ActualSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualSpend(Spend actualSpend);

        /**
         * Sets the value of the ForecastedSpend property for this object.
         *
         * @param forecastedSpend
         *        The new value for the ForecastedSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedSpend(Spend forecastedSpend);
    }

    private static final class BuilderImpl implements Builder {
        private Spend actualSpend;

        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            setActualSpend(model.actualSpend);
            setForecastedSpend(model.forecastedSpend);
        }

        public final Spend getActualSpend() {
            return actualSpend;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
        }

        public final Spend getForecastedSpend() {
            return forecastedSpend;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
        }

        @Override
        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }
    }
}
