/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of UpdateSubscriber
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateSubscriberRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateSubscriberRequest.Builder, UpdateSubscriberRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final Subscriber oldSubscriber;

    private final Subscriber newSubscriber;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.oldSubscriber = builder.oldSubscriber;
        this.newSubscriber = builder.newSubscriber;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the Notification property for this object.
     * 
     * @return The value of the Notification property for this object.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * Returns the value of the OldSubscriber property for this object.
     * 
     * @return The value of the OldSubscriber property for this object.
     */
    public Subscriber oldSubscriber() {
        return oldSubscriber;
    }

    /**
     * Returns the value of the NewSubscriber property for this object.
     * 
     * @return The value of the NewSubscriber property for this object.
     */
    public Subscriber newSubscriber() {
        return newSubscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((oldSubscriber() == null) ? 0 : oldSubscriber().hashCode());
        hashCode = 31 * hashCode + ((newSubscriber() == null) ? 0 : newSubscriber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.oldSubscriber() == null ^ this.oldSubscriber() == null) {
            return false;
        }
        if (other.oldSubscriber() != null && !other.oldSubscriber().equals(this.oldSubscriber())) {
            return false;
        }
        if (other.newSubscriber() == null ^ this.newSubscriber() == null) {
            return false;
        }
        if (other.newSubscriber() != null && !other.newSubscriber().equals(this.newSubscriber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (oldSubscriber() != null) {
            sb.append("OldSubscriber: ").append(oldSubscriber()).append(",");
        }
        if (newSubscriber() != null) {
            sb.append("NewSubscriber: ").append(newSubscriber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateSubscriberRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the Notification property for this object.
         *
         * @param notification
         *        The new value for the Notification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * Sets the value of the OldSubscriber property for this object.
         *
         * @param oldSubscriber
         *        The new value for the OldSubscriber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldSubscriber(Subscriber oldSubscriber);

        /**
         * Sets the value of the NewSubscriber property for this object.
         *
         * @param newSubscriber
         *        The new value for the NewSubscriber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newSubscriber(Subscriber newSubscriber);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private Subscriber oldSubscriber;

        private Subscriber newSubscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            setAccountId(model.accountId);
            setBudgetName(model.budgetName);
            setNotification(model.notification);
            setOldSubscriber(model.oldSubscriber);
            setNewSubscriber(model.newSubscriber);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final Subscriber getOldSubscriber() {
            return oldSubscriber;
        }

        @Override
        public final Builder oldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
            return this;
        }

        public final void setOldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
        }

        public final Subscriber getNewSubscriber() {
            return newSubscriber;
        }

        @Override
        public final Builder newSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
            return this;
        }

        public final void setNewSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
        }

        @Override
        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }
    }
}
