/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.transform.CalculatedSpendMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CalculatedSpend
implements StructuredPojo,
ToCopyableBuilder<Builder, CalculatedSpend> {
    private final Spend actualSpend;
    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    public Spend actualSpend() {
        return this.actualSpend;
    }

    public Spend forecastedSpend() {
        return this.forecastedSpend;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actualSpend() == null ? 0 : this.actualSpend().hashCode());
        hashCode = 31 * hashCode + (this.forecastedSpend() == null ? 0 : this.forecastedSpend().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend)obj;
        if (other.actualSpend() == null ^ this.actualSpend() == null) {
            return false;
        }
        if (other.actualSpend() != null && !other.actualSpend().equals(this.actualSpend())) {
            return false;
        }
        if (other.forecastedSpend() == null ^ this.forecastedSpend() == null) {
            return false;
        }
        return other.forecastedSpend() == null || other.forecastedSpend().equals(this.forecastedSpend());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actualSpend() != null) {
            sb.append("ActualSpend: ").append(this.actualSpend()).append(",");
        }
        if (this.forecastedSpend() != null) {
            sb.append("ForecastedSpend: ").append(this.forecastedSpend()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CalculatedSpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Spend actualSpend;
        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            this.setActualSpend(model.actualSpend);
            this.setForecastedSpend(model.forecastedSpend);
        }

        public final Spend getActualSpend() {
            return this.actualSpend;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
        }

        public final Spend getForecastedSpend() {
            return this.forecastedSpend;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
        }

        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CalculatedSpend> {
        public Builder actualSpend(Spend var1);

        public Builder forecastedSpend(Spend var1);
    }
}

