/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.BudgetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * AWS Budget model
 */
@Generated("software.amazon.awssdk:codegen")
public class Budget implements StructuredPojo, ToCopyableBuilder<Budget.Builder, Budget> {
    private final String budgetName;

    private final Spend budgetLimit;

    private final Map<String, List<String>> costFilters;

    private final CostTypes costTypes;

    private final String timeUnit;

    private final TimePeriod timePeriod;

    private final CalculatedSpend calculatedSpend;

    private final String budgetType;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the BudgetLimit property for this object.
     * 
     * @return The value of the BudgetLimit property for this object.
     */
    public Spend budgetLimit() {
        return budgetLimit;
    }

    /**
     * Returns the value of the CostFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CostFilters property for this object.
     */
    public Map<String, List<String>> costFilters() {
        return costFilters;
    }

    /**
     * Returns the value of the CostTypes property for this object.
     * 
     * @return The value of the CostTypes property for this object.
     */
    public CostTypes costTypes() {
        return costTypes;
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public String timeUnit() {
        return timeUnit;
    }

    /**
     * Returns the value of the TimePeriod property for this object.
     * 
     * @return The value of the TimePeriod property for this object.
     */
    public TimePeriod timePeriod() {
        return timePeriod;
    }

    /**
     * Returns the value of the CalculatedSpend property for this object.
     * 
     * @return The value of the CalculatedSpend property for this object.
     */
    public CalculatedSpend calculatedSpend() {
        return calculatedSpend;
    }

    /**
     * Returns the value of the BudgetType property for this object.
     * 
     * @return The value of the BudgetType property for this object.
     * @see BudgetType
     */
    public String budgetType() {
        return budgetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((budgetLimit() == null) ? 0 : budgetLimit().hashCode());
        hashCode = 31 * hashCode + ((costFilters() == null) ? 0 : costFilters().hashCode());
        hashCode = 31 * hashCode + ((costTypes() == null) ? 0 : costTypes().hashCode());
        hashCode = 31 * hashCode + ((timeUnit() == null) ? 0 : timeUnit().hashCode());
        hashCode = 31 * hashCode + ((timePeriod() == null) ? 0 : timePeriod().hashCode());
        hashCode = 31 * hashCode + ((calculatedSpend() == null) ? 0 : calculatedSpend().hashCode());
        hashCode = 31 * hashCode + ((budgetType() == null) ? 0 : budgetType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget) obj;
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.budgetLimit() == null ^ this.budgetLimit() == null) {
            return false;
        }
        if (other.budgetLimit() != null && !other.budgetLimit().equals(this.budgetLimit())) {
            return false;
        }
        if (other.costFilters() == null ^ this.costFilters() == null) {
            return false;
        }
        if (other.costFilters() != null && !other.costFilters().equals(this.costFilters())) {
            return false;
        }
        if (other.costTypes() == null ^ this.costTypes() == null) {
            return false;
        }
        if (other.costTypes() != null && !other.costTypes().equals(this.costTypes())) {
            return false;
        }
        if (other.timeUnit() == null ^ this.timeUnit() == null) {
            return false;
        }
        if (other.timeUnit() != null && !other.timeUnit().equals(this.timeUnit())) {
            return false;
        }
        if (other.timePeriod() == null ^ this.timePeriod() == null) {
            return false;
        }
        if (other.timePeriod() != null && !other.timePeriod().equals(this.timePeriod())) {
            return false;
        }
        if (other.calculatedSpend() == null ^ this.calculatedSpend() == null) {
            return false;
        }
        if (other.calculatedSpend() != null && !other.calculatedSpend().equals(this.calculatedSpend())) {
            return false;
        }
        if (other.budgetType() == null ^ this.budgetType() == null) {
            return false;
        }
        if (other.budgetType() != null && !other.budgetType().equals(this.budgetType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (budgetLimit() != null) {
            sb.append("BudgetLimit: ").append(budgetLimit()).append(",");
        }
        if (costFilters() != null) {
            sb.append("CostFilters: ").append(costFilters()).append(",");
        }
        if (costTypes() != null) {
            sb.append("CostTypes: ").append(costTypes()).append(",");
        }
        if (timeUnit() != null) {
            sb.append("TimeUnit: ").append(timeUnit()).append(",");
        }
        if (timePeriod() != null) {
            sb.append("TimePeriod: ").append(timePeriod()).append(",");
        }
        if (calculatedSpend() != null) {
            sb.append("CalculatedSpend: ").append(calculatedSpend()).append(",");
        }
        if (budgetType() != null) {
            sb.append("BudgetType: ").append(budgetType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Budget> {
        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the BudgetLimit property for this object.
         *
         * @param budgetLimit
         *        The new value for the BudgetLimit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetLimit(Spend budgetLimit);

        /**
         * Sets the value of the CostFilters property for this object.
         *
         * @param costFilters
         *        The new value for the CostFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costFilters(Map<String, ? extends Collection<String>> costFilters);

        /**
         * Sets the value of the CostTypes property for this object.
         *
         * @param costTypes
         *        The new value for the CostTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costTypes(CostTypes costTypes);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(String timeUnit);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(TimeUnit timeUnit);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * @param timePeriod
         *        The new value for the TimePeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(TimePeriod timePeriod);

        /**
         * Sets the value of the CalculatedSpend property for this object.
         *
         * @param calculatedSpend
         *        The new value for the CalculatedSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedSpend(CalculatedSpend calculatedSpend);

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(String budgetType);

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(BudgetType budgetType);
    }

    private static final class BuilderImpl implements Builder {
        private String budgetName;

        private Spend budgetLimit;

        private Map<String, List<String>> costFilters;

        private CostTypes costTypes;

        private String timeUnit;

        private TimePeriod timePeriod;

        private CalculatedSpend calculatedSpend;

        private String budgetType;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            setBudgetName(model.budgetName);
            setBudgetLimit(model.budgetLimit);
            setCostFilters(model.costFilters);
            setCostTypes(model.costTypes);
            setTimeUnit(model.timeUnit);
            setTimePeriod(model.timePeriod);
            setCalculatedSpend(model.calculatedSpend);
            setBudgetType(model.budgetType);
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Spend getBudgetLimit() {
            return budgetLimit;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final void setBudgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            return costFilters;
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        public final CostTypes getCostTypes() {
            return costTypes;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final void setCostTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
        }

        public final String getTimeUnit() {
            return timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final TimePeriod getTimePeriod() {
            return timePeriod;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
        }

        public final CalculatedSpend getCalculatedSpend() {
            return calculatedSpend;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final void setCalculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
        }

        public final String getBudgetType() {
            return budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType.toString());
            return this;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public Budget build() {
            return new Budget(this);
        }
    }
}
