/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.budgets.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Budget JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BudgetUnmarshaller implements Unmarshaller<Budget, JsonUnmarshallerContext> {

    public Budget unmarshall(JsonUnmarshallerContext context) throws Exception {
        Budget.Builder budgetBuilder = Budget.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BudgetName", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BudgetLimit", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetLimit(SpendUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CostFilters", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.costFilters(new MapUnmarshaller<String, java.util.List<String>>(context
                            .getUnmarshaller(String.class), new ListUnmarshaller<String>(context.getUnmarshaller(String.class)))
                            .unmarshall(context));
                }
                if (context.testExpression("CostTypes", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.costTypes(CostTypesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TimeUnit", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.timeUnit(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TimePeriod", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.timePeriod(TimePeriodUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CalculatedSpend", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.calculatedSpend(CalculatedSpendUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BudgetType", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return budgetBuilder.build();
    }

    private static final BudgetUnmarshaller INSTANCE = new BudgetUnmarshaller();

    public static BudgetUnmarshaller getInstance() {
        return INSTANCE;
    }
}
