/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubscribersForNotificationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSubscribersForNotificationResponse> {
    private final List<Subscriber> subscribers;
    private final String nextToken;

    private DescribeSubscribersForNotificationResponse(BuilderImpl builder) {
        this.subscribers = builder.subscribers;
        this.nextToken = builder.nextToken;
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscribers() == null ? 0 : this.subscribers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribersForNotificationResponse)) {
            return false;
        }
        DescribeSubscribersForNotificationResponse other = (DescribeSubscribersForNotificationResponse)((Object)obj);
        if (other.subscribers() == null ^ this.subscribers() == null) {
            return false;
        }
        if (other.subscribers() != null && !other.subscribers().equals(this.subscribers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscribers() != null) {
            sb.append("Subscribers: ").append(this.subscribers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Subscriber> subscribers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribersForNotificationResponse model) {
            this.setSubscribers(model.subscribers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Subscriber> getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeSubscribersForNotificationResponse build() {
            return new DescribeSubscribersForNotificationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubscribersForNotificationResponse> {
        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder nextToken(String var1);
    }
}

