/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.CreateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.CreateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AWSBudgets asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * All public APIs for AWS Budgets
 */
@Generated("software.amazon.awssdk:codegen")
public interface BudgetsAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link BudgetsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static BudgetsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BudgetsAsyncClient}.
     */
    static BudgetsAsyncClientBuilder builder() {
        return new DefaultBudgetsAsyncClientBuilder();
    }

    /**
     * Create a new budget
     *
     * @param createBudgetRequest
     *        Request of CreateBudget
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudget
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(CreateBudgetRequest createBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new Notification with subscribers for a budget
     *
     * @param createNotificationRequest
     *        Request of CreateNotification
     * @return A Java Future containing the result of the CreateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateNotification
     */
    default CompletableFuture<CreateNotificationResponse> createNotification(CreateNotificationRequest createNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new Subscriber for a notification
     *
     * @param createSubscriberRequest
     *        Request of CreateSubscriber
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateSubscriber
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a budget and related notifications
     *
     * @param deleteBudgetRequest
     *        Request of DeleteBudget
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudget
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a notification and related subscribers
     *
     * @param deleteNotificationRequest
     *        Request of DeleteNotification
     * @return A Java Future containing the result of the DeleteNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteNotification
     */
    default CompletableFuture<DeleteNotificationResponse> deleteNotification(DeleteNotificationRequest deleteNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a Subscriber for a notification
     *
     * @param deleteSubscriberRequest
     *        Request of DeleteSubscriber
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteSubscriber
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a single budget
     *
     * @param describeBudgetRequest
     *        Request of DescribeBudget
     * @return A Java Future containing the result of the DescribeBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudget
     */
    default CompletableFuture<DescribeBudgetResponse> describeBudget(DescribeBudgetRequest describeBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get all budgets for an account
     *
     * @param describeBudgetsRequest
     *        Request of DescribeBudgets
     * @return A Java Future containing the result of the DescribeBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default CompletableFuture<DescribeBudgetsResponse> describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get notifications of a budget
     *
     * @param describeNotificationsForBudgetRequest
     *        Request of DescribeNotificationsForBudget
     * @return A Java Future containing the result of the DescribeNotificationsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default CompletableFuture<DescribeNotificationsForBudgetResponse> describeNotificationsForBudget(
            DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get subscribers of a notification
     *
     * @param describeSubscribersForNotificationRequest
     *        Request of DescribeSubscribersForNotification
     * @return A Java Future containing the result of the DescribeSubscribersForNotification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default CompletableFuture<DescribeSubscribersForNotificationResponse> describeSubscribersForNotification(
            DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update the information of a budget already created
     *
     * @param updateBudgetRequest
     *        Request of UpdateBudget
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudget
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update the information about a notification already created
     *
     * @param updateNotificationRequest
     *        Request of UpdateNotification
     * @return A Java Future containing the result of the UpdateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateNotification
     */
    default CompletableFuture<UpdateNotificationResponse> updateNotification(UpdateNotificationRequest updateNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a subscriber
     *
     * @param updateSubscriberRequest
     *        Request of UpdateSubscriber
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateSubscriber
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        throw new UnsupportedOperationException();
    }
}
