/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateNotificationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateNotificationRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification oldNotification;
    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification oldNotification() {
        return this.oldNotification;
    }

    public Notification newNotification() {
        return this.newNotification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.budgetName() == null ? 0 : this.budgetName().hashCode());
        hashCode = 31 * hashCode + (this.oldNotification() == null ? 0 : this.oldNotification().hashCode());
        hashCode = 31 * hashCode + (this.newNotification() == null ? 0 : this.newNotification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.oldNotification() == null ^ this.oldNotification() == null) {
            return false;
        }
        if (other.oldNotification() != null && !other.oldNotification().equals(this.oldNotification())) {
            return false;
        }
        if (other.newNotification() == null ^ this.newNotification() == null) {
            return false;
        }
        return other.newNotification() == null || other.newNotification().equals(this.newNotification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.oldNotification() != null) {
            sb.append("OldNotification: ").append(this.oldNotification()).append(",");
        }
        if (this.newNotification() != null) {
            sb.append("NewNotification: ").append(this.newNotification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification oldNotification;
        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            this.setAccountId(model.accountId);
            this.setBudgetName(model.budgetName);
            this.setOldNotification(model.oldNotification);
            this.setNewNotification(model.newNotification);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getOldNotification() {
            return this.oldNotification;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final void setOldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
        }

        public final Notification getNewNotification() {
            return this.newNotification;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        public final void setNewNotification(Notification newNotification) {
            this.newNotification = newNotification;
        }

        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateNotificationRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder oldNotification(Notification var1);

        public Builder newNotification(Notification var1);
    }
}

