/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of DeleteSubscriber
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteSubscriberRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteSubscriberRequest.Builder, DeleteSubscriberRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final Subscriber subscriber;

    private DeleteSubscriberRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.subscriber = builder.subscriber;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the Notification property for this object.
     * 
     * @return The value of the Notification property for this object.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * Returns the value of the Subscriber property for this object.
     * 
     * @return The value of the Subscriber property for this object.
     */
    public Subscriber subscriber() {
        return subscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((subscriber() == null) ? 0 : subscriber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubscriberRequest)) {
            return false;
        }
        DeleteSubscriberRequest other = (DeleteSubscriberRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.subscriber() == null ^ this.subscriber() == null) {
            return false;
        }
        if (other.subscriber() != null && !other.subscriber().equals(this.subscriber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (subscriber() != null) {
            sb.append("Subscriber: ").append(subscriber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.of(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.of(clazz.cast(budgetName()));
        case "Notification":
            return Optional.of(clazz.cast(notification()));
        case "Subscriber":
            return Optional.of(clazz.cast(subscriber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteSubscriberRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the Notification property for this object.
         *
         * @param notification
         *        The new value for the Notification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * Sets the value of the Subscriber property for this object.
         *
         * @param subscriber
         *        The new value for the Subscriber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriber(Subscriber subscriber);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private Subscriber subscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubscriberRequest model) {
            accountId(model.accountId);
            budgetName(model.budgetName);
            notification(model.notification);
            subscriber(model.subscriber);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Subscriber.Builder getSubscriber() {
            return subscriber != null ? subscriber.toBuilder() : null;
        }

        @Override
        public final Builder subscriber(Subscriber subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public final void setSubscriber(Subscriber.BuilderImpl subscriber) {
            this.subscriber = subscriber != null ? subscriber.build() : null;
        }

        @Override
        public DeleteSubscriberRequest build() {
            return new DeleteSubscriberRequest(this);
        }
    }
}
