/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBudgetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeBudgetResponse.Builder, DescribeBudgetResponse> {
    private final Budget budget;

    private DescribeBudgetResponse(BuilderImpl builder) {
        this.budget = builder.budget;
    }

    /**
     * Returns the value of the Budget property for this object.
     * 
     * @return The value of the Budget property for this object.
     */
    public Budget budget() {
        return budget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((budget() == null) ? 0 : budget().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetResponse)) {
            return false;
        }
        DescribeBudgetResponse other = (DescribeBudgetResponse) obj;
        if (other.budget() == null ^ this.budget() == null) {
            return false;
        }
        if (other.budget() != null && !other.budget().equals(this.budget())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (budget() != null) {
            sb.append("Budget: ").append(budget()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Budget":
            return Optional.of(clazz.cast(budget()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeBudgetResponse> {
        /**
         * Sets the value of the Budget property for this object.
         *
         * @param budget
         *        The new value for the Budget property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);
    }

    static final class BuilderImpl implements Builder {
        private Budget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetResponse model) {
            budget(model.budget);
        }

        public final Budget.Builder getBudget() {
            return budget != null ? budget.toBuilder() : null;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        public DescribeBudgetResponse build() {
            return new DescribeBudgetResponse(this);
        }
    }
}
