/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeBudgets
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBudgetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeBudgetsResponse.Builder, DescribeBudgetsResponse> {
    private final List<Budget> budgets;

    private final String nextToken;

    private DescribeBudgetsResponse(BuilderImpl builder) {
        this.budgets = builder.budgets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Budgets property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Budgets property for this object.
     */
    public List<Budget> budgets() {
        return budgets;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((budgets() == null) ? 0 : budgets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetsResponse)) {
            return false;
        }
        DescribeBudgetsResponse other = (DescribeBudgetsResponse) obj;
        if (other.budgets() == null ^ this.budgets() == null) {
            return false;
        }
        if (other.budgets() != null && !other.budgets().equals(this.budgets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (budgets() != null) {
            sb.append("Budgets: ").append(budgets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Budgets":
            return Optional.of(clazz.cast(budgets()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeBudgetsResponse> {
        /**
         * Sets the value of the Budgets property for this object.
         *
         * @param budgets
         *        The new value for the Budgets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Collection<Budget> budgets);

        /**
         * Sets the value of the Budgets property for this object.
         *
         * @param budgets
         *        The new value for the Budgets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Budget... budgets);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Budget> budgets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetsResponse model) {
            budgets(model.budgets);
            nextToken(model.nextToken);
        }

        public final Collection<Budget.Builder> getBudgets() {
            return budgets != null ? budgets.stream().map(Budget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Budget... budgets) {
            budgets(Arrays.asList(budgets));
            return this;
        }

        public final void setBudgets(Collection<Budget.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetsResponse build() {
            return new DescribeBudgetsResponse(this);
        }
    }
}
