/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.NotificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Notification model. Each budget may contain multiple notifications with different settings.
 */
@Generated("software.amazon.awssdk:codegen")
public class Notification implements StructuredPojo, ToCopyableBuilder<Notification.Builder, Notification> {
    private final String notificationType;

    private final String comparisonOperator;

    private final Double threshold;

    private Notification(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public String notificationTypeString() {
        return notificationType;
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see ComparisonOperator
     */
    public String comparisonOperatorString() {
        return comparisonOperator;
    }

    /**
     * Returns the value of the Threshold property for this object.
     * 
     * @return The value of the Threshold property for this object.
     */
    public Double threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((notificationTypeString() == null) ? 0 : notificationTypeString().hashCode());
        hashCode = 31 * hashCode + ((comparisonOperatorString() == null) ? 0 : comparisonOperatorString().hashCode());
        hashCode = 31 * hashCode + ((threshold() == null) ? 0 : threshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification) obj;
        if (other.notificationTypeString() == null ^ this.notificationTypeString() == null) {
            return false;
        }
        if (other.notificationTypeString() != null && !other.notificationTypeString().equals(this.notificationTypeString())) {
            return false;
        }
        if (other.comparisonOperatorString() == null ^ this.comparisonOperatorString() == null) {
            return false;
        }
        if (other.comparisonOperatorString() != null && !other.comparisonOperatorString().equals(this.comparisonOperatorString())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (notificationTypeString() != null) {
            sb.append("NotificationType: ").append(notificationTypeString()).append(",");
        }
        if (comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(comparisonOperatorString()).append(",");
        }
        if (threshold() != null) {
            sb.append("Threshold: ").append(threshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationType":
            return Optional.of(clazz.cast(notificationTypeString()));
        case "ComparisonOperator":
            return Optional.of(clazz.cast(comparisonOperatorString()));
        case "Threshold":
            return Optional.of(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Notification> {
        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * Sets the value of the Threshold property for this object.
         *
         * @param threshold
         *        The new value for the Threshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);
    }

    static final class BuilderImpl implements Builder {
        private String notificationType;

        private String comparisonOperator;

        private Double threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            notificationType(model.notificationType);
            comparisonOperator(model.comparisonOperator);
            threshold(model.threshold);
        }

        public final String getNotificationType() {
            return notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public Notification build() {
            return new Notification(this);
        }
    }
}
