/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.SubscriberMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Subscriber model. Each notification may contain multiple subscribers with different addresses.
 */
@Generated("software.amazon.awssdk:codegen")
public class Subscriber implements StructuredPojo, ToCopyableBuilder<Subscriber.Builder, Subscriber> {
    private final String subscriptionType;

    private final String address;

    private Subscriber(BuilderImpl builder) {
        this.subscriptionType = builder.subscriptionType;
        this.address = builder.address;
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(subscriptionType);
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public String subscriptionTypeString() {
        return subscriptionType;
    }

    /**
     * Returns the value of the Address property for this object.
     * 
     * @return The value of the Address property for this object.
     */
    public String address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscriptionTypeString() == null) ? 0 : subscriptionTypeString().hashCode());
        hashCode = 31 * hashCode + ((address() == null) ? 0 : address().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscriber)) {
            return false;
        }
        Subscriber other = (Subscriber) obj;
        if (other.subscriptionTypeString() == null ^ this.subscriptionTypeString() == null) {
            return false;
        }
        if (other.subscriptionTypeString() != null && !other.subscriptionTypeString().equals(this.subscriptionTypeString())) {
            return false;
        }
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        if (other.address() != null && !other.address().equals(this.address())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (subscriptionTypeString() != null) {
            sb.append("SubscriptionType: ").append(subscriptionTypeString()).append(",");
        }
        if (address() != null) {
            sb.append("Address: ").append(address()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionType":
            return Optional.of(clazz.cast(subscriptionTypeString()));
        case "Address":
            return Optional.of(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriberMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Subscriber> {
        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(String subscriptionType);

        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(SubscriptionType subscriptionType);

        /**
         * Sets the value of the Address property for this object.
         *
         * @param address
         *        The new value for the Address property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);
    }

    static final class BuilderImpl implements Builder {
        private String subscriptionType;

        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscriber model) {
            subscriptionType(model.subscriptionType);
            address(model.address);
        }

        public final String getSubscriptionType() {
            return subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public Subscriber build() {
            return new Subscriber(this);
        }
    }
}
