/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of UpdateBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateBudgetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateBudgetRequest.Builder, UpdateBudgetRequest> {
    private final String accountId;

    private final Budget newBudget;

    private UpdateBudgetRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.newBudget = builder.newBudget;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the NewBudget property for this object.
     * 
     * @return The value of the NewBudget property for this object.
     */
    public Budget newBudget() {
        return newBudget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((newBudget() == null) ? 0 : newBudget().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.newBudget() == null ^ this.newBudget() == null) {
            return false;
        }
        if (other.newBudget() != null && !other.newBudget().equals(this.newBudget())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (newBudget() != null) {
            sb.append("NewBudget: ").append(newBudget()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.of(clazz.cast(accountId()));
        case "NewBudget":
            return Optional.of(clazz.cast(newBudget()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateBudgetRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the NewBudget property for this object.
         *
         * @param newBudget
         *        The new value for the NewBudget property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newBudget(Budget newBudget);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Budget newBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            accountId(model.accountId);
            newBudget(model.newBudget);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget.Builder getNewBudget() {
            return newBudget != null ? newBudget.toBuilder() : null;
        }

        @Override
        public final Builder newBudget(Budget newBudget) {
            this.newBudget = newBudget;
            return this;
        }

        public final void setNewBudget(Budget.BuilderImpl newBudget) {
            this.newBudget = newBudget != null ? newBudget.build() : null;
        }

        @Override
        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }
    }
}
