/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.budgets.model.BudgetsException;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.CreateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.CreateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.CreationLimitExceededException;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DuplicateRecordException;
import software.amazon.awssdk.services.budgets.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.budgets.model.InternalErrorException;
import software.amazon.awssdk.services.budgets.model.InvalidNextTokenException;
import software.amazon.awssdk.services.budgets.model.InvalidParameterException;
import software.amazon.awssdk.services.budgets.model.NotFoundException;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.budgets.transform.CreateBudgetRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.CreateBudgetResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.CreateNotificationRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.CreateNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.CreateSubscriberRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.CreateSubscriberResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteBudgetRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteBudgetResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteNotificationRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteSubscriberRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DeleteSubscriberResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeBudgetRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeBudgetResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeBudgetsRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeBudgetsResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeNotificationsForBudgetRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeNotificationsForBudgetResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeSubscribersForNotificationRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.DescribeSubscribersForNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateBudgetRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateBudgetResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateNotificationRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateSubscriberRequestMarshaller;
import software.amazon.awssdk.services.budgets.transform.UpdateSubscriberResponseUnmarshaller;

/**
 * Internal implementation of {@link BudgetsClient}.
 *
 * @see BudgetsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBudgetsClient implements BudgetsClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final ClientConfiguration clientConfiguration;

    protected DefaultBudgetsClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    /**
     * Create a new budget
     *
     * @param createBudgetRequest
     *        Request of CreateBudget
     * @return Result of the CreateBudget operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws CreationLimitExceededException
     *         The exception is thrown when customer tries to create a record (e.g. budget), but the number this record
     *         already exceeds the limitation.
     * @throws DuplicateRecordException
     *         The exception is thrown when customer tries to create a record (e.g. budget) that already exists.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.CreateBudget
     */
    @Override
    public CreateBudgetResponse createBudget(CreateBudgetRequest createBudgetRequest) throws InvalidParameterException,
            InternalErrorException, CreationLimitExceededException, DuplicateRecordException, SdkBaseException,
            SdkClientException, BudgetsException {

        HttpResponseHandler<CreateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateBudgetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateBudgetRequest, CreateBudgetResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createBudgetRequest).withMarshaller(new CreateBudgetRequestMarshaller(protocolFactory)));
    }

    /**
     * Create a new Notification with subscribers for a budget
     *
     * @param createNotificationRequest
     *        Request of CreateNotification
     * @return Result of the CreateNotification operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws CreationLimitExceededException
     *         The exception is thrown when customer tries to create a record (e.g. budget), but the number this record
     *         already exceeds the limitation.
     * @throws DuplicateRecordException
     *         The exception is thrown when customer tries to create a record (e.g. budget) that already exists.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.CreateNotification
     */
    @Override
    public CreateNotificationResponse createNotification(CreateNotificationRequest createNotificationRequest)
            throws InternalErrorException, InvalidParameterException, NotFoundException, CreationLimitExceededException,
            DuplicateRecordException, SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<CreateNotificationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateNotificationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateNotificationRequest, CreateNotificationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createNotificationRequest).withMarshaller(new CreateNotificationRequestMarshaller(protocolFactory)));
    }

    /**
     * Create a new Subscriber for a notification
     *
     * @param createSubscriberRequest
     *        Request of CreateSubscriber
     * @return Result of the CreateSubscriber operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws CreationLimitExceededException
     *         The exception is thrown when customer tries to create a record (e.g. budget), but the number this record
     *         already exceeds the limitation.
     * @throws DuplicateRecordException
     *         The exception is thrown when customer tries to create a record (e.g. budget) that already exists.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.CreateSubscriber
     */
    @Override
    public CreateSubscriberResponse createSubscriber(CreateSubscriberRequest createSubscriberRequest)
            throws InternalErrorException, InvalidParameterException, CreationLimitExceededException, DuplicateRecordException,
            NotFoundException, SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<CreateSubscriberResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateSubscriberResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateSubscriberRequest, CreateSubscriberResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createSubscriberRequest).withMarshaller(new CreateSubscriberRequestMarshaller(protocolFactory)));
    }

    /**
     * Delete a budget and related notifications
     *
     * @param deleteBudgetRequest
     *        Request of DeleteBudget
     * @return Result of the DeleteBudget operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DeleteBudget
     */
    @Override
    public DeleteBudgetResponse deleteBudget(DeleteBudgetRequest deleteBudgetRequest) throws InternalErrorException,
            InvalidParameterException, NotFoundException, SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<DeleteBudgetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBudgetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBudgetRequest, DeleteBudgetResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteBudgetRequest).withMarshaller(new DeleteBudgetRequestMarshaller(protocolFactory)));
    }

    /**
     * Delete a notification and related subscribers
     *
     * @param deleteNotificationRequest
     *        Request of DeleteNotification
     * @return Result of the DeleteNotification operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DeleteNotification
     */
    @Override
    public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest deleteNotificationRequest)
            throws InvalidParameterException, InternalErrorException, NotFoundException, SdkBaseException, SdkClientException,
            BudgetsException {

        HttpResponseHandler<DeleteNotificationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteNotificationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteNotificationRequest, DeleteNotificationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteNotificationRequest).withMarshaller(new DeleteNotificationRequestMarshaller(protocolFactory)));
    }

    /**
     * Delete a Subscriber for a notification
     *
     * @param deleteSubscriberRequest
     *        Request of DeleteSubscriber
     * @return Result of the DeleteSubscriber operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DeleteSubscriber
     */
    @Override
    public DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest)
            throws InternalErrorException, InvalidParameterException, NotFoundException, SdkBaseException, SdkClientException,
            BudgetsException {

        HttpResponseHandler<DeleteSubscriberResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSubscriberResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSubscriberRequest, DeleteSubscriberResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteSubscriberRequest).withMarshaller(new DeleteSubscriberRequestMarshaller(protocolFactory)));
    }

    /**
     * Get a single budget
     *
     * @param describeBudgetRequest
     *        Request of DescribeBudget
     * @return Result of the DescribeBudget operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DescribeBudget
     */
    @Override
    public DescribeBudgetResponse describeBudget(DescribeBudgetRequest describeBudgetRequest) throws InternalErrorException,
            InvalidParameterException, NotFoundException, SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<DescribeBudgetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeBudgetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeBudgetRequest, DescribeBudgetResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeBudgetRequest).withMarshaller(new DescribeBudgetRequestMarshaller(protocolFactory)));
    }

    /**
     * Get all budgets for an account
     *
     * @param describeBudgetsRequest
     *        Request of DescribeBudgets
     * @return Result of the DescribeBudgets operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws InvalidNextTokenException
     *         This exception is thrown if paging token signature didn't match the token, or the paging token isn't for
     *         this request
     * @throws ExpiredNextTokenException
     *         This exception is thrown if the paging token is expired - past its TTL
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DescribeBudgets
     */
    @Override
    public DescribeBudgetsResponse describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) throws InternalErrorException,
            InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, SdkBaseException,
            SdkClientException, BudgetsException {

        HttpResponseHandler<DescribeBudgetsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeBudgetsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeBudgetsRequest, DescribeBudgetsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeBudgetsRequest).withMarshaller(new DescribeBudgetsRequestMarshaller(protocolFactory)));
    }

    /**
     * Get notifications of a budget
     *
     * @param describeNotificationsForBudgetRequest
     *        Request of DescribeNotificationsForBudget
     * @return Result of the DescribeNotificationsForBudget operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws InvalidNextTokenException
     *         This exception is thrown if paging token signature didn't match the token, or the paging token isn't for
     *         this request
     * @throws ExpiredNextTokenException
     *         This exception is thrown if the paging token is expired - past its TTL
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DescribeNotificationsForBudget
     */
    @Override
    public DescribeNotificationsForBudgetResponse describeNotificationsForBudget(
            DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) throws InternalErrorException,
            InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, SdkBaseException,
            SdkClientException, BudgetsException {

        HttpResponseHandler<DescribeNotificationsForBudgetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeNotificationsForBudgetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeNotificationsForBudgetRequest, DescribeNotificationsForBudgetResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeNotificationsForBudgetRequest)
                        .withMarshaller(new DescribeNotificationsForBudgetRequestMarshaller(protocolFactory)));
    }

    /**
     * Get subscribers of a notification
     *
     * @param describeSubscribersForNotificationRequest
     *        Request of DescribeSubscribersForNotification
     * @return Result of the DescribeSubscribersForNotification operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws InvalidNextTokenException
     *         This exception is thrown if paging token signature didn't match the token, or the paging token isn't for
     *         this request
     * @throws ExpiredNextTokenException
     *         This exception is thrown if the paging token is expired - past its TTL
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.DescribeSubscribersForNotification
     */
    @Override
    public DescribeSubscribersForNotificationResponse describeSubscribersForNotification(
            DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) throws InternalErrorException,
            NotFoundException, InvalidParameterException, InvalidNextTokenException, ExpiredNextTokenException, SdkBaseException,
            SdkClientException, BudgetsException {

        HttpResponseHandler<DescribeSubscribersForNotificationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeSubscribersForNotificationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSubscribersForNotificationRequest, DescribeSubscribersForNotificationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeSubscribersForNotificationRequest)
                        .withMarshaller(new DescribeSubscribersForNotificationRequestMarshaller(protocolFactory)));
    }

    /**
     * Update the information of a budget already created
     *
     * @param updateBudgetRequest
     *        Request of UpdateBudget
     * @return Result of the UpdateBudget operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.UpdateBudget
     */
    @Override
    public UpdateBudgetResponse updateBudget(UpdateBudgetRequest updateBudgetRequest) throws InternalErrorException,
            InvalidParameterException, NotFoundException, SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<UpdateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateBudgetResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateBudgetRequest, UpdateBudgetResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateBudgetRequest).withMarshaller(new UpdateBudgetRequestMarshaller(protocolFactory)));
    }

    /**
     * Update the information about a notification already created
     *
     * @param updateNotificationRequest
     *        Request of UpdateNotification
     * @return Result of the UpdateNotification operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws DuplicateRecordException
     *         The exception is thrown when customer tries to create a record (e.g. budget) that already exists.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.UpdateNotification
     */
    @Override
    public UpdateNotificationResponse updateNotification(UpdateNotificationRequest updateNotificationRequest)
            throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException,
            SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<UpdateNotificationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateNotificationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateNotificationRequest, UpdateNotificationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateNotificationRequest).withMarshaller(new UpdateNotificationRequestMarshaller(protocolFactory)));
    }

    /**
     * Update a subscriber
     *
     * @param updateSubscriberRequest
     *        Request of UpdateSubscriber
     * @return Result of the UpdateSubscriber operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown on an unknown internal failure.
     * @throws InvalidParameterException
     *         This exception is thrown if any request is given an invalid parameter. E.g., if a required Date field is
     *         null.
     * @throws NotFoundException
     *         This exception is thrown if a requested entity is not found. E.g., if a budget id doesn't exist for an
     *         account ID.
     * @throws DuplicateRecordException
     *         The exception is thrown when customer tries to create a record (e.g. budget) that already exists.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BudgetsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BudgetsClient.UpdateSubscriber
     */
    @Override
    public UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest)
            throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException,
            SdkBaseException, SdkClientException, BudgetsException {

        HttpResponseHandler<UpdateSubscriberResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateSubscriberResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateSubscriberRequest, UpdateSubscriberResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateSubscriberRequest).withMarshaller(new UpdateSubscriberRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(
                new JsonClientMetadata()
                        .withProtocolVersion("1.1")
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.budgets.model.BudgetsException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(
                                        InvalidParameterException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("DuplicateRecordException").withModeledClass(
                                        DuplicateRecordException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(
                                        InternalErrorException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("CreationLimitExceededException").withModeledClass(
                                        CreationLimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(
                                        InvalidNextTokenException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(
                                        ExpiredNextTokenException.class)));
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
