/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotificationsForBudgetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeNotificationsForBudgetRequest> {
    private final String accountId;
    private final String budgetName;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeNotificationsForBudgetRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationsForBudgetRequest)) {
            return false;
        }
        DescribeNotificationsForBudgetRequest other = (DescribeNotificationsForBudgetRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.of(clazz.cast(this.budgetName()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationsForBudgetRequest model) {
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNotificationsForBudgetRequest build() {
            return new DescribeNotificationsForBudgetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNotificationsForBudgetRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

