/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.ComparisonOperator;
import software.amazon.awssdk.services.budgets.model.NotificationType;
import software.amazon.awssdk.services.budgets.model.ThresholdType;
import software.amazon.awssdk.services.budgets.transform.NotificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Notification
implements StructuredPojo,
ToCopyableBuilder<Builder, Notification> {
    private final String notificationType;
    private final String comparisonOperator;
    private final Double threshold;
    private final String thresholdType;

    private Notification(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.thresholdType = builder.thresholdType;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeString() {
        return this.notificationType;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ThresholdType thresholdType() {
        return ThresholdType.fromValue(this.thresholdType);
    }

    public String thresholdTypeString() {
        return this.thresholdType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return Objects.equals(this.notificationTypeString(), other.notificationTypeString()) && Objects.equals(this.comparisonOperatorString(), other.comparisonOperatorString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.thresholdTypeString(), other.thresholdTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.notificationTypeString() != null) {
            sb.append("NotificationType: ").append(this.notificationTypeString()).append(",");
        }
        if (this.comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperatorString()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.thresholdTypeString() != null) {
            sb.append("ThresholdType: ").append(this.thresholdTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationType": {
                return Optional.of(clazz.cast(this.notificationTypeString()));
            }
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
            case "Threshold": {
                return Optional.of(clazz.cast(this.threshold()));
            }
            case "ThresholdType": {
                return Optional.of(clazz.cast(this.thresholdTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String notificationType;
        private String comparisonOperator;
        private Double threshold;
        private String thresholdType;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.notificationType(model.notificationType);
            this.comparisonOperator(model.comparisonOperator);
            this.threshold(model.threshold);
            this.thresholdType(model.thresholdType);
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getThresholdType() {
            return this.thresholdType;
        }

        @Override
        public final Builder thresholdType(String thresholdType) {
            this.thresholdType = thresholdType;
            return this;
        }

        @Override
        public final Builder thresholdType(ThresholdType thresholdType) {
            this.thresholdType(thresholdType.toString());
            return this;
        }

        public final void setThresholdType(String thresholdType) {
            this.thresholdType = thresholdType;
        }

        public Notification build() {
            return new Notification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Notification> {
        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder threshold(Double var1);

        public Builder thresholdType(String var1);

        public Builder thresholdType(ThresholdType var1);
    }
}

