/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSubscriberRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSubscriberRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification notification;
    private final Subscriber oldSubscriber;
    private final Subscriber newSubscriber;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.oldSubscriber = builder.oldSubscriber;
        this.newSubscriber = builder.newSubscriber;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public Subscriber oldSubscriber() {
        return this.oldSubscriber;
    }

    public Subscriber newSubscriber() {
        return this.newSubscriber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(this.newSubscriber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.oldSubscriber(), other.oldSubscriber()) && Objects.equals(this.newSubscriber(), other.newSubscriber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.oldSubscriber() != null) {
            sb.append("OldSubscriber: ").append(this.oldSubscriber()).append(",");
        }
        if (this.newSubscriber() != null) {
            sb.append("NewSubscriber: ").append(this.newSubscriber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.of(clazz.cast(this.budgetName()));
            }
            case "Notification": {
                return Optional.of(clazz.cast(this.notification()));
            }
            case "OldSubscriber": {
                return Optional.of(clazz.cast(this.oldSubscriber()));
            }
            case "NewSubscriber": {
                return Optional.of(clazz.cast(this.newSubscriber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;
        private Subscriber oldSubscriber;
        private Subscriber newSubscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.notification(model.notification);
            this.oldSubscriber(model.oldSubscriber);
            this.newSubscriber(model.newSubscriber);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Subscriber.Builder getOldSubscriber() {
            return this.oldSubscriber != null ? this.oldSubscriber.toBuilder() : null;
        }

        @Override
        public final Builder oldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
            return this;
        }

        public final void setOldSubscriber(Subscriber.BuilderImpl oldSubscriber) {
            this.oldSubscriber = oldSubscriber != null ? oldSubscriber.build() : null;
        }

        public final Subscriber.Builder getNewSubscriber() {
            return this.newSubscriber != null ? this.newSubscriber.toBuilder() : null;
        }

        @Override
        public final Builder newSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
            return this;
        }

        public final void setNewSubscriber(Subscriber.BuilderImpl newSubscriber) {
            this.newSubscriber = newSubscriber != null ? newSubscriber.build() : null;
        }

        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSubscriberRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().apply(notification)).build());
        }

        public Builder oldSubscriber(Subscriber var1);

        default public Builder oldSubscriber(Consumer<Subscriber.Builder> oldSubscriber) {
            return this.oldSubscriber((Subscriber)((Subscriber.Builder)Subscriber.builder().apply(oldSubscriber)).build());
        }

        public Builder newSubscriber(Subscriber var1);

        default public Builder newSubscriber(Consumer<Subscriber.Builder> newSubscriber) {
            return this.newSubscriber((Subscriber)((Subscriber.Builder)Subscriber.builder().apply(newSubscriber)).build());
        }
    }
}

