/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.BudgetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * AWS Budget model
 */
@Generated("software.amazon.awssdk:codegen")
public class Budget implements StructuredPojo, ToCopyableBuilder<Budget.Builder, Budget> {
    private final String budgetName;

    private final Spend budgetLimit;

    private final Map<String, List<String>> costFilters;

    private final CostTypes costTypes;

    private final String timeUnit;

    private final TimePeriod timePeriod;

    private final CalculatedSpend calculatedSpend;

    private final String budgetType;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the BudgetLimit property for this object.
     * 
     * @return The value of the BudgetLimit property for this object.
     */
    public Spend budgetLimit() {
        return budgetLimit;
    }

    /**
     * Returns the value of the CostFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CostFilters property for this object.
     */
    public Map<String, List<String>> costFilters() {
        return costFilters;
    }

    /**
     * Returns the value of the CostTypes property for this object.
     * 
     * @return The value of the CostTypes property for this object.
     */
    public CostTypes costTypes() {
        return costTypes;
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public TimeUnit timeUnit() {
        return TimeUnit.fromValue(timeUnit);
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public String timeUnitString() {
        return timeUnit;
    }

    /**
     * Returns the value of the TimePeriod property for this object.
     * 
     * @return The value of the TimePeriod property for this object.
     */
    public TimePeriod timePeriod() {
        return timePeriod;
    }

    /**
     * Returns the value of the CalculatedSpend property for this object.
     * 
     * @return The value of the CalculatedSpend property for this object.
     */
    public CalculatedSpend calculatedSpend() {
        return calculatedSpend;
    }

    /**
     * Returns the value of the BudgetType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link BudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeString}.
     * </p>
     * 
     * @return The value of the BudgetType property for this object.
     * @see BudgetType
     */
    public BudgetType budgetType() {
        return BudgetType.fromValue(budgetType);
    }

    /**
     * Returns the value of the BudgetType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link BudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeString}.
     * </p>
     * 
     * @return The value of the BudgetType property for this object.
     * @see BudgetType
     */
    public String budgetTypeString() {
        return budgetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(budgetLimit());
        hashCode = 31 * hashCode + Objects.hashCode(costFilters());
        hashCode = 31 * hashCode + Objects.hashCode(costTypes());
        hashCode = 31 * hashCode + Objects.hashCode(timeUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedSpend());
        hashCode = 31 * hashCode + Objects.hashCode(budgetTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget) obj;
        return Objects.equals(budgetName(), other.budgetName()) && Objects.equals(budgetLimit(), other.budgetLimit())
                && Objects.equals(costFilters(), other.costFilters()) && Objects.equals(costTypes(), other.costTypes())
                && Objects.equals(timeUnitString(), other.timeUnitString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(calculatedSpend(), other.calculatedSpend())
                && Objects.equals(budgetTypeString(), other.budgetTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (budgetLimit() != null) {
            sb.append("BudgetLimit: ").append(budgetLimit()).append(",");
        }
        if (costFilters() != null) {
            sb.append("CostFilters: ").append(costFilters()).append(",");
        }
        if (costTypes() != null) {
            sb.append("CostTypes: ").append(costTypes()).append(",");
        }
        if (timeUnitString() != null) {
            sb.append("TimeUnit: ").append(timeUnitString()).append(",");
        }
        if (timePeriod() != null) {
            sb.append("TimePeriod: ").append(timePeriod()).append(",");
        }
        if (calculatedSpend() != null) {
            sb.append("CalculatedSpend: ").append(calculatedSpend()).append(",");
        }
        if (budgetTypeString() != null) {
            sb.append("BudgetType: ").append(budgetTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetName":
            return Optional.of(clazz.cast(budgetName()));
        case "BudgetLimit":
            return Optional.of(clazz.cast(budgetLimit()));
        case "CostFilters":
            return Optional.of(clazz.cast(costFilters()));
        case "CostTypes":
            return Optional.of(clazz.cast(costTypes()));
        case "TimeUnit":
            return Optional.of(clazz.cast(timeUnitString()));
        case "TimePeriod":
            return Optional.of(clazz.cast(timePeriod()));
        case "CalculatedSpend":
            return Optional.of(clazz.cast(calculatedSpend()));
        case "BudgetType":
            return Optional.of(clazz.cast(budgetTypeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Budget> {
        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the BudgetLimit property for this object.
         *
         * @param budgetLimit
         *        The new value for the BudgetLimit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetLimit(Spend budgetLimit);

        /**
         * Sets the value of the BudgetLimit property for this object.
         *
         * This is a convenience that creates an instance of the {@link Spend.Builder} avoiding the need to create one
         * manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #budgetLimit(Spend)}.
         * 
         * @param budgetLimit
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetLimit(Spend)
         */
        default Builder budgetLimit(Consumer<Spend.Builder> budgetLimit) {
            return budgetLimit(Spend.builder().apply(budgetLimit).build());
        }

        /**
         * Sets the value of the CostFilters property for this object.
         *
         * @param costFilters
         *        The new value for the CostFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costFilters(Map<String, ? extends Collection<String>> costFilters);

        /**
         * Sets the value of the CostTypes property for this object.
         *
         * @param costTypes
         *        The new value for the CostTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costTypes(CostTypes costTypes);

        /**
         * Sets the value of the CostTypes property for this object.
         *
         * This is a convenience that creates an instance of the {@link CostTypes.Builder} avoiding the need to create
         * one manually via {@link CostTypes#builder()}.
         *
         * When the {@link Consumer} completes, {@link CostTypes.Builder#build()} is called immediately and its result
         * is passed to {@link #costTypes(CostTypes)}.
         * 
         * @param costTypes
         *        a consumer that will call methods on {@link CostTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costTypes(CostTypes)
         */
        default Builder costTypes(Consumer<CostTypes.Builder> costTypes) {
            return costTypes(CostTypes.builder().apply(costTypes).build());
        }

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(String timeUnit);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(TimeUnit timeUnit);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * @param timePeriod
         *        The new value for the TimePeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(TimePeriod timePeriod);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * This is a convenience that creates an instance of the {@link TimePeriod.Builder} avoiding the need to create
         * one manually via {@link TimePeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimePeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #timePeriod(TimePeriod)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link TimePeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(TimePeriod)
         */
        default Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return timePeriod(TimePeriod.builder().apply(timePeriod).build());
        }

        /**
         * Sets the value of the CalculatedSpend property for this object.
         *
         * @param calculatedSpend
         *        The new value for the CalculatedSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedSpend(CalculatedSpend calculatedSpend);

        /**
         * Sets the value of the CalculatedSpend property for this object.
         *
         * This is a convenience that creates an instance of the {@link CalculatedSpend.Builder} avoiding the need to
         * create one manually via {@link CalculatedSpend#builder()}.
         *
         * When the {@link Consumer} completes, {@link CalculatedSpend.Builder#build()} is called immediately and its
         * result is passed to {@link #calculatedSpend(CalculatedSpend)}.
         * 
         * @param calculatedSpend
         *        a consumer that will call methods on {@link CalculatedSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedSpend(CalculatedSpend)
         */
        default Builder calculatedSpend(Consumer<CalculatedSpend.Builder> calculatedSpend) {
            return calculatedSpend(CalculatedSpend.builder().apply(calculatedSpend).build());
        }

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(String budgetType);

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(BudgetType budgetType);
    }

    static final class BuilderImpl implements Builder {
        private String budgetName;

        private Spend budgetLimit;

        private Map<String, List<String>> costFilters;

        private CostTypes costTypes;

        private String timeUnit;

        private TimePeriod timePeriod;

        private CalculatedSpend calculatedSpend;

        private String budgetType;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            budgetName(model.budgetName);
            budgetLimit(model.budgetLimit);
            costFilters(model.costFilters);
            costTypes(model.costTypes);
            timeUnit(model.timeUnit);
            timePeriod(model.timePeriod);
            calculatedSpend(model.calculatedSpend);
            budgetType(model.budgetType);
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Spend.Builder getBudgetLimit() {
            return budgetLimit != null ? budgetLimit.toBuilder() : null;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final void setBudgetLimit(Spend.BuilderImpl budgetLimit) {
            this.budgetLimit = budgetLimit != null ? budgetLimit.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            return costFilters;
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        public final CostTypes.Builder getCostTypes() {
            return costTypes != null ? costTypes.toBuilder() : null;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        public final String getTimeUnit() {
            return timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final CalculatedSpend.Builder getCalculatedSpend() {
            return calculatedSpend != null ? calculatedSpend.toBuilder() : null;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final void setCalculatedSpend(CalculatedSpend.BuilderImpl calculatedSpend) {
            this.calculatedSpend = calculatedSpend != null ? calculatedSpend.build() : null;
        }

        public final String getBudgetType() {
            return budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType.toString());
            return this;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public Budget build() {
            return new Budget(this);
        }
    }
}
