/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.CalculatedSpendMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A structure that holds the actual and forecasted spend for a budget.
 */
@Generated("software.amazon.awssdk:codegen")
public class CalculatedSpend implements StructuredPojo, ToCopyableBuilder<CalculatedSpend.Builder, CalculatedSpend> {
    private final Spend actualSpend;

    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    /**
     * Returns the value of the ActualSpend property for this object.
     * 
     * @return The value of the ActualSpend property for this object.
     */
    public Spend actualSpend() {
        return actualSpend;
    }

    /**
     * Returns the value of the ForecastedSpend property for this object.
     * 
     * @return The value of the ForecastedSpend property for this object.
     */
    public Spend forecastedSpend() {
        return forecastedSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actualSpend());
        hashCode = 31 * hashCode + Objects.hashCode(forecastedSpend());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend) obj;
        return Objects.equals(actualSpend(), other.actualSpend()) && Objects.equals(forecastedSpend(), other.forecastedSpend());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (actualSpend() != null) {
            sb.append("ActualSpend: ").append(actualSpend()).append(",");
        }
        if (forecastedSpend() != null) {
            sb.append("ForecastedSpend: ").append(forecastedSpend()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActualSpend":
            return Optional.of(clazz.cast(actualSpend()));
        case "ForecastedSpend":
            return Optional.of(clazz.cast(forecastedSpend()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CalculatedSpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CalculatedSpend> {
        /**
         * Sets the value of the ActualSpend property for this object.
         *
         * @param actualSpend
         *        The new value for the ActualSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualSpend(Spend actualSpend);

        /**
         * Sets the value of the ActualSpend property for this object.
         *
         * This is a convenience that creates an instance of the {@link Spend.Builder} avoiding the need to create one
         * manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #actualSpend(Spend)}.
         * 
         * @param actualSpend
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualSpend(Spend)
         */
        default Builder actualSpend(Consumer<Spend.Builder> actualSpend) {
            return actualSpend(Spend.builder().apply(actualSpend).build());
        }

        /**
         * Sets the value of the ForecastedSpend property for this object.
         *
         * @param forecastedSpend
         *        The new value for the ForecastedSpend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedSpend(Spend forecastedSpend);

        /**
         * Sets the value of the ForecastedSpend property for this object.
         *
         * This is a convenience that creates an instance of the {@link Spend.Builder} avoiding the need to create one
         * manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #forecastedSpend(Spend)}.
         * 
         * @param forecastedSpend
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastedSpend(Spend)
         */
        default Builder forecastedSpend(Consumer<Spend.Builder> forecastedSpend) {
            return forecastedSpend(Spend.builder().apply(forecastedSpend).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Spend actualSpend;

        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            actualSpend(model.actualSpend);
            forecastedSpend(model.forecastedSpend);
        }

        public final Spend.Builder getActualSpend() {
            return actualSpend != null ? actualSpend.toBuilder() : null;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend.BuilderImpl actualSpend) {
            this.actualSpend = actualSpend != null ? actualSpend.build() : null;
        }

        public final Spend.Builder getForecastedSpend() {
            return forecastedSpend != null ? forecastedSpend.toBuilder() : null;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend.BuilderImpl forecastedSpend) {
            this.forecastedSpend = forecastedSpend != null ? forecastedSpend.build() : null;
        }

        @Override
        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }
    }
}
