/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of UpdateBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateBudgetRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateBudgetRequest.Builder, UpdateBudgetRequest> {
    private final String accountId;

    private final Budget newBudget;

    private UpdateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.newBudget = builder.newBudget;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the NewBudget property for this object.
     * 
     * @return The value of the NewBudget property for this object.
     */
    public Budget newBudget() {
        return newBudget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(newBudget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(newBudget(), other.newBudget());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (newBudget() != null) {
            sb.append("NewBudget: ").append(newBudget()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.of(clazz.cast(accountId()));
        case "NewBudget":
            return Optional.of(clazz.cast(newBudget()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BudgetsRequest.Builder, CopyableBuilder<Builder, UpdateBudgetRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the NewBudget property for this object.
         *
         * @param newBudget
         *        The new value for the NewBudget property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newBudget(Budget newBudget);

        /**
         * Sets the value of the NewBudget property for this object.
         *
         * This is a convenience that creates an instance of the {@link Budget.Builder} avoiding the need to create one
         * manually via {@link Budget#builder()}.
         *
         * When the {@link Consumer} completes, {@link Budget.Builder#build()} is called immediately and its result is
         * passed to {@link #newBudget(Budget)}.
         * 
         * @param newBudget
         *        a consumer that will call methods on {@link Budget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newBudget(Budget)
         */
        default Builder newBudget(Consumer<Budget.Builder> newBudget) {
            return newBudget(Budget.builder().apply(newBudget).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private Budget newBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            accountId(model.accountId);
            newBudget(model.newBudget);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget.Builder getNewBudget() {
            return newBudget != null ? newBudget.toBuilder() : null;
        }

        @Override
        public final Builder newBudget(Budget newBudget) {
            this.newBudget = newBudget;
            return this;
        }

        public final void setNewBudget(Budget.BuilderImpl newBudget) {
            this.newBudget = newBudget != null ? newBudget.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }
    }
}
