/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of UpdateNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateNotificationRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateNotificationRequest.Builder, UpdateNotificationRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification oldNotification;

    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the OldNotification property for this object.
     * 
     * @return The value of the OldNotification property for this object.
     */
    public Notification oldNotification() {
        return oldNotification;
    }

    /**
     * Returns the value of the NewNotification property for this object.
     * 
     * @return The value of the NewNotification property for this object.
     */
    public Notification newNotification() {
        return newNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(oldNotification());
        hashCode = 31 * hashCode + Objects.hashCode(newNotification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(oldNotification(), other.oldNotification())
                && Objects.equals(newNotification(), other.newNotification());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (oldNotification() != null) {
            sb.append("OldNotification: ").append(oldNotification()).append(",");
        }
        if (newNotification() != null) {
            sb.append("NewNotification: ").append(newNotification()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.of(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.of(clazz.cast(budgetName()));
        case "OldNotification":
            return Optional.of(clazz.cast(oldNotification()));
        case "NewNotification":
            return Optional.of(clazz.cast(newNotification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BudgetsRequest.Builder, CopyableBuilder<Builder, UpdateNotificationRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the OldNotification property for this object.
         *
         * @param oldNotification
         *        The new value for the OldNotification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldNotification(Notification oldNotification);

        /**
         * Sets the value of the OldNotification property for this object.
         *
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #oldNotification(Notification)}.
         * 
         * @param oldNotification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oldNotification(Notification)
         */
        default Builder oldNotification(Consumer<Notification.Builder> oldNotification) {
            return oldNotification(Notification.builder().apply(oldNotification).build());
        }

        /**
         * Sets the value of the NewNotification property for this object.
         *
         * @param newNotification
         *        The new value for the NewNotification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newNotification(Notification newNotification);

        /**
         * Sets the value of the NewNotification property for this object.
         *
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #newNotification(Notification)}.
         * 
         * @param newNotification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newNotification(Notification)
         */
        default Builder newNotification(Consumer<Notification.Builder> newNotification) {
            return newNotification(Notification.builder().apply(newNotification).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification oldNotification;

        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            accountId(model.accountId);
            budgetName(model.budgetName);
            oldNotification(model.oldNotification);
            newNotification(model.newNotification);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getOldNotification() {
            return oldNotification != null ? oldNotification.toBuilder() : null;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final void setOldNotification(Notification.BuilderImpl oldNotification) {
            this.oldNotification = oldNotification != null ? oldNotification.build() : null;
        }

        public final Notification.Builder getNewNotification() {
            return newNotification != null ? newNotification.toBuilder() : null;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        public final void setNewNotification(Notification.BuilderImpl newNotification) {
            this.newNotification = newNotification != null ? newNotification.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }
    }
}
