/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Budget;

@SdkInternalApi
public class BudgetMarshaller {
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").build();
    private static final MarshallingInfo<StructuredPojo> BUDGETLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetLimit").build();
    private static final MarshallingInfo<Map> COSTFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostFilters").build();
    private static final MarshallingInfo<StructuredPojo> COSTTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostTypes").build();
    private static final MarshallingInfo<String> TIMEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeUnit").build();
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").build();
    private static final MarshallingInfo<StructuredPojo> CALCULATEDSPEND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CalculatedSpend").build();
    private static final MarshallingInfo<String> BUDGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetType").build();
    private static final BudgetMarshaller INSTANCE = new BudgetMarshaller();

    public static BudgetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Budget budget, ProtocolMarshaller protocolMarshaller) {
        if (budget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)budget.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall((Object)budget.budgetLimit(), BUDGETLIMIT_BINDING);
            protocolMarshaller.marshall(budget.costFilters(), COSTFILTERS_BINDING);
            protocolMarshaller.marshall((Object)budget.costTypes(), COSTTYPES_BINDING);
            protocolMarshaller.marshall((Object)budget.timeUnitString(), TIMEUNIT_BINDING);
            protocolMarshaller.marshall((Object)budget.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)budget.calculatedSpend(), CALCULATEDSPEND_BINDING);
            protocolMarshaller.marshall((Object)budget.budgetTypeString(), BUDGETTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

