/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;

@SdkInternalApi
public class CreateBudgetRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<StructuredPojo> BUDGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Budget").build();
    private static final MarshallingInfo<List> NOTIFICATIONSWITHSUBSCRIBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationsWithSubscribers").build();
    private static final CreateBudgetRequestModelMarshaller INSTANCE = new CreateBudgetRequestModelMarshaller();

    public static CreateBudgetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateBudgetRequest createBudgetRequest, ProtocolMarshaller protocolMarshaller) {
        if (createBudgetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createBudgetRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)createBudgetRequest.budget(), BUDGET_BINDING);
            protocolMarshaller.marshall(createBudgetRequest.notificationsWithSubscribers(), NOTIFICATIONSWITHSUBSCRIBERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

