/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Notification;

@SdkInternalApi
public class NotificationMarshaller {
    private static final MarshallingInfo<String> NOTIFICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationType").build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Threshold").build();
    private static final MarshallingInfo<String> THRESHOLDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThresholdType").build();
    private static final NotificationMarshaller INSTANCE = new NotificationMarshaller();

    public static NotificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Notification notification, ProtocolMarshaller protocolMarshaller) {
        if (notification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)notification.notificationTypeString(), NOTIFICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)notification.comparisonOperatorString(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)notification.threshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)notification.thresholdTypeString(), THRESHOLDTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

