/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateNotificationRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, UpdateNotificationRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification oldNotification;
    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification oldNotification() {
        return this.oldNotification;
    }

    public Notification newNotification() {
        return this.newNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.newNotification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.oldNotification(), other.oldNotification()) && Objects.equals(this.newNotification(), other.newNotification());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotificationRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("OldNotification", (Object)this.oldNotification()).add("NewNotification", (Object)this.newNotification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.of(clazz.cast(this.budgetName()));
            }
            case "OldNotification": {
                return Optional.of(clazz.cast(this.oldNotification()));
            }
            case "NewNotification": {
                return Optional.of(clazz.cast(this.newNotification()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification oldNotification;
        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.oldNotification(model.oldNotification);
            this.newNotification(model.newNotification);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getOldNotification() {
            return this.oldNotification != null ? this.oldNotification.toBuilder() : null;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final void setOldNotification(Notification.BuilderImpl oldNotification) {
            this.oldNotification = oldNotification != null ? oldNotification.build() : null;
        }

        public final Notification.Builder getNewNotification() {
            return this.newNotification != null ? this.newNotification.toBuilder() : null;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        public final void setNewNotification(Notification.BuilderImpl newNotification) {
            this.newNotification = newNotification != null ? newNotification.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    CopyableBuilder<Builder, UpdateNotificationRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder oldNotification(Notification var1);

        default public Builder oldNotification(Consumer<Notification.Builder> oldNotification) {
            return this.oldNotification((Notification)((Notification.Builder)Notification.builder().apply(oldNotification)).build());
        }

        public Builder newNotification(Notification var1);

        default public Builder newNotification(Consumer<Notification.Builder> newNotification) {
            return this.newNotification((Notification)((Notification.Builder)Notification.builder().apply(newNotification)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

