/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of GetNotificationsForBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNotificationsForBudgetResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeNotificationsForBudgetResponse.Builder, DescribeNotificationsForBudgetResponse> {
    private final List<Notification> notifications;

    private final String nextToken;

    private DescribeNotificationsForBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Notifications property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Notifications property for this object.
     */
    public List<Notification> notifications() {
        return notifications;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationsForBudgetResponse)) {
            return false;
        }
        DescribeNotificationsForBudgetResponse other = (DescribeNotificationsForBudgetResponse) obj;
        return Objects.equals(notifications(), other.notifications()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNotificationsForBudgetResponse").add("Notifications", notifications())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Notifications":
            return Optional.of(clazz.cast(notifications()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BudgetsResponse.Builder, CopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
        /**
         * Sets the value of the Notifications property for this object.
         *
         * @param notifications
         *        The new value for the Notifications property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Collection<Notification> notifications);

        /**
         * Sets the value of the Notifications property for this object.
         *
         * @param notifications
         *        The new value for the Notifications property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Notification... notifications);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<Notification> notifications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationsForBudgetResponse model) {
            notifications(model.notifications);
            nextToken(model.nextToken);
        }

        public final Collection<Notification.Builder> getNotifications() {
            return notifications != null ? notifications.stream().map(Notification::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification... notifications) {
            notifications(Arrays.asList(notifications));
            return this;
        }

        public final void setNotifications(Collection<Notification.BuilderImpl> notifications) {
            this.notifications = NotificationsCopier.copyFromBuilder(notifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationsForBudgetResponse build() {
            return new DescribeNotificationsForBudgetResponse(this);
        }
    }
}
