/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeSubscribersForNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubscribersForNotificationResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeSubscribersForNotificationResponse.Builder, DescribeSubscribersForNotificationResponse> {
    private final List<Subscriber> subscribers;

    private final String nextToken;

    private DescribeSubscribersForNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.subscribers = builder.subscribers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Subscribers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Subscribers property for this object.
     */
    public List<Subscriber> subscribers() {
        return subscribers;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscribers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribersForNotificationResponse)) {
            return false;
        }
        DescribeSubscribersForNotificationResponse other = (DescribeSubscribersForNotificationResponse) obj;
        return Objects.equals(subscribers(), other.subscribers()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSubscribersForNotificationResponse").add("Subscribers", subscribers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscribers":
            return Optional.of(clazz.cast(subscribers()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BudgetsResponse.Builder,
            CopyableBuilder<Builder, DescribeSubscribersForNotificationResponse> {
        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<Subscriber> subscribers;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribersForNotificationResponse model) {
            subscribers(model.subscribers);
            nextToken(model.nextToken);
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return subscribers != null ? subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscribersForNotificationResponse build() {
            return new DescribeSubscribersForNotificationResponse(this);
        }
    }
}
