/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.NotificationWithSubscribersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A structure to relate notification and a list of subscribers who belong to the notification.
 */
@Generated("software.amazon.awssdk:codegen")
public class NotificationWithSubscribers implements StructuredPojo,
        ToCopyableBuilder<NotificationWithSubscribers.Builder, NotificationWithSubscribers> {
    private final Notification notification;

    private final List<Subscriber> subscribers;

    private NotificationWithSubscribers(BuilderImpl builder) {
        this.notification = builder.notification;
        this.subscribers = builder.subscribers;
    }

    /**
     * Returns the value of the Notification property for this object.
     * 
     * @return The value of the Notification property for this object.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * Returns the value of the Subscribers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Subscribers property for this object.
     */
    public List<Subscriber> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(subscribers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationWithSubscribers)) {
            return false;
        }
        NotificationWithSubscribers other = (NotificationWithSubscribers) obj;
        return Objects.equals(notification(), other.notification()) && Objects.equals(subscribers(), other.subscribers());
    }

    @Override
    public String toString() {
        return ToString.builder("NotificationWithSubscribers").add("Notification", notification())
                .add("Subscribers", subscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Notification":
            return Optional.of(clazz.cast(notification()));
        case "Subscribers":
            return Optional.of(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationWithSubscribersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationWithSubscribers> {
        /**
         * Sets the value of the Notification property for this object.
         *
         * @param notification
         *        The new value for the Notification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * Sets the value of the Notification property for this object.
         *
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().apply(notification).build());
        }

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);
    }

    static final class BuilderImpl implements Builder {
        private Notification notification;

        private List<Subscriber> subscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationWithSubscribers model) {
            notification(model.notification);
            subscribers(model.subscribers);
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return subscribers != null ? subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public NotificationWithSubscribers build() {
            return new NotificationWithSubscribers(this);
        }
    }
}
