/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CostTypes} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CostTypesMarshaller {
    private static final MarshallingInfo<Boolean> INCLUDETAX_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeTax").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDESUBSCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeSubscription").isBinary(false).build();

    private static final MarshallingInfo<Boolean> USEBLENDED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseBlended").isBinary(false).build();

    private static final CostTypesMarshaller INSTANCE = new CostTypesMarshaller();

    private CostTypesMarshaller() {
    }

    public static CostTypesMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CostTypes costTypes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(costTypes, "costTypes");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(costTypes.includeTax(), INCLUDETAX_BINDING);
            protocolMarshaller.marshall(costTypes.includeSubscription(), INCLUDESUBSCRIPTION_BINDING);
            protocolMarshaller.marshall(costTypes.useBlended(), USEBLENDED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
