/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BudgetType {
    USAGE("USAGE"),
    COST("COST"),
    RI_UTILIZATION("RI_UTILIZATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BudgetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BudgetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BudgetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BudgetType> knownValues() {
        return Stream.of(BudgetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

