/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response of DescribeSubscribersForNotification
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubscribersForNotificationResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeSubscribersForNotificationResponse.Builder, DescribeSubscribersForNotificationResponse> {
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField
            .<List<Subscriber>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSubscribersForNotificationResponse::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscriber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSubscribersForNotificationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Subscriber> subscribers;

    private final String nextToken;

    private DescribeSubscribersForNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.subscribers = builder.subscribers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of subscribers that are associated with a notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of subscribers that are associated with a notification.
     */
    public List<Subscriber> subscribers() {
        return subscribers;
    }

    /**
     * <p>
     * The pagination token in the service response that indicates the next set of results that you can retrieve.
     * </p>
     * 
     * @return The pagination token in the service response that indicates the next set of results that you can
     *         retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscribers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribersForNotificationResponse)) {
            return false;
        }
        DescribeSubscribersForNotificationResponse other = (DescribeSubscribersForNotificationResponse) obj;
        return Objects.equals(subscribers(), other.subscribers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSubscribersForNotificationResponse").add("Subscribers", subscribers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubscribersForNotificationResponse, T> g) {
        return obj -> g.apply((DescribeSubscribersForNotificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSubscribersForNotificationResponse> {
        /**
         * <p>
         * A list of subscribers that are associated with a notification.
         * </p>
         * 
         * @param subscribers
         *        A list of subscribers that are associated with a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * <p>
         * A list of subscribers that are associated with a notification.
         * </p>
         * 
         * @param subscribers
         *        A list of subscribers that are associated with a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         * <p>
         * A list of subscribers that are associated with a notification.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Subscriber>.Builder} avoiding the need to
         * create one manually via {@link List<Subscriber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subscriber>.Builder#build()} is called immediately and its
         * result is passed to {@link #subscribers(List<Subscriber>)}.
         * 
         * @param subscribers
         *        a consumer that will call methods on {@link List<Subscriber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribers(List<Subscriber>)
         */
        Builder subscribers(Consumer<Subscriber.Builder>... subscribers);

        /**
         * <p>
         * The pagination token in the service response that indicates the next set of results that you can retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token in the service response that indicates the next set of results that you can
         *        retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribersForNotificationResponse model) {
            super(model);
            subscribers(model.subscribers);
            nextToken(model.nextToken);
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return subscribers != null ? subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder>... subscribers) {
            subscribers(Stream.of(subscribers).map(c -> Subscriber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscribersForNotificationResponse build() {
            return new DescribeSubscribersForNotificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
