/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The spend objects that are associated with this budget. The <code>actualSpend</code> tracks how much you've used,
 * cost, usage, or RI units, and the <code>forecastedSpend</code> tracks how much you are predicted to spend if your
 * current usage remains steady.
 * </p>
 * <p>
 * For example, if it is the 20th of the month and you have spent <code>50</code> dollars on Amazon EC2, your
 * <code>actualSpend</code> is <code>50 USD</code>, and your <code>forecastedSpend</code> is <code>75 USD</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculatedSpend implements SdkPojo, Serializable, ToCopyableBuilder<CalculatedSpend.Builder, CalculatedSpend> {
    private static final SdkField<Spend> ACTUAL_SPEND_FIELD = SdkField.<Spend> builder(MarshallingType.SDK_POJO)
            .getter(getter(CalculatedSpend::actualSpend)).setter(setter(Builder::actualSpend)).constructor(Spend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualSpend").build()).build();

    private static final SdkField<Spend> FORECASTED_SPEND_FIELD = SdkField.<Spend> builder(MarshallingType.SDK_POJO)
            .getter(getter(CalculatedSpend::forecastedSpend)).setter(setter(Builder::forecastedSpend))
            .constructor(Spend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedSpend").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_SPEND_FIELD,
            FORECASTED_SPEND_FIELD));

    private static final long serialVersionUID = 1L;

    private final Spend actualSpend;

    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    /**
     * <p>
     * The amount of cost, usage, or RI units that you have used.
     * </p>
     * 
     * @return The amount of cost, usage, or RI units that you have used.
     */
    public Spend actualSpend() {
        return actualSpend;
    }

    /**
     * <p>
     * The amount of cost, usage, or RI units that you are forecasted to use.
     * </p>
     * 
     * @return The amount of cost, usage, or RI units that you are forecasted to use.
     */
    public Spend forecastedSpend() {
        return forecastedSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actualSpend());
        hashCode = 31 * hashCode + Objects.hashCode(forecastedSpend());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend) obj;
        return Objects.equals(actualSpend(), other.actualSpend()) && Objects.equals(forecastedSpend(), other.forecastedSpend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CalculatedSpend").add("ActualSpend", actualSpend()).add("ForecastedSpend", forecastedSpend())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActualSpend":
            return Optional.ofNullable(clazz.cast(actualSpend()));
        case "ForecastedSpend":
            return Optional.ofNullable(clazz.cast(forecastedSpend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculatedSpend, T> g) {
        return obj -> g.apply((CalculatedSpend) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculatedSpend> {
        /**
         * <p>
         * The amount of cost, usage, or RI units that you have used.
         * </p>
         * 
         * @param actualSpend
         *        The amount of cost, usage, or RI units that you have used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualSpend(Spend actualSpend);

        /**
         * <p>
         * The amount of cost, usage, or RI units that you have used.
         * </p>
         * This is a convenience that creates an instance of the {@link Spend.Builder} avoiding the need to create one
         * manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #actualSpend(Spend)}.
         * 
         * @param actualSpend
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualSpend(Spend)
         */
        default Builder actualSpend(Consumer<Spend.Builder> actualSpend) {
            return actualSpend(Spend.builder().applyMutation(actualSpend).build());
        }

        /**
         * <p>
         * The amount of cost, usage, or RI units that you are forecasted to use.
         * </p>
         * 
         * @param forecastedSpend
         *        The amount of cost, usage, or RI units that you are forecasted to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedSpend(Spend forecastedSpend);

        /**
         * <p>
         * The amount of cost, usage, or RI units that you are forecasted to use.
         * </p>
         * This is a convenience that creates an instance of the {@link Spend.Builder} avoiding the need to create one
         * manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #forecastedSpend(Spend)}.
         * 
         * @param forecastedSpend
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastedSpend(Spend)
         */
        default Builder forecastedSpend(Consumer<Spend.Builder> forecastedSpend) {
            return forecastedSpend(Spend.builder().applyMutation(forecastedSpend).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Spend actualSpend;

        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            actualSpend(model.actualSpend);
            forecastedSpend(model.forecastedSpend);
        }

        public final Spend.Builder getActualSpend() {
            return actualSpend != null ? actualSpend.toBuilder() : null;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend.BuilderImpl actualSpend) {
            this.actualSpend = actualSpend != null ? actualSpend.build() : null;
        }

        public final Spend.Builder getForecastedSpend() {
            return forecastedSpend != null ? forecastedSpend.toBuilder() : null;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend.BuilderImpl forecastedSpend) {
            this.forecastedSpend = forecastedSpend != null ? forecastedSpend.build() : null;
        }

        @Override
        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
