/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBudgetActionHistoriesResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeBudgetActionHistoriesResponse.Builder, DescribeBudgetActionHistoriesResponse> {
    private static final SdkField<List<ActionHistory>> ACTION_HISTORIES_FIELD = SdkField
            .<List<ActionHistory>> builder(MarshallingType.LIST)
            .memberName("ActionHistories")
            .getter(getter(DescribeBudgetActionHistoriesResponse::actionHistories))
            .setter(setter(Builder::actionHistories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionHistories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeBudgetActionHistoriesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_HISTORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ActionHistory> actionHistories;

    private final String nextToken;

    private DescribeBudgetActionHistoriesResponse(BuilderImpl builder) {
        super(builder);
        this.actionHistories = builder.actionHistories;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ActionHistories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasActionHistories() {
        return actionHistories != null && !(actionHistories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The historical record of the budget action resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionHistories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The historical record of the budget action resource.
     */
    public List<ActionHistory> actionHistories() {
        return actionHistories;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionHistories() ? actionHistories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetActionHistoriesResponse)) {
            return false;
        }
        DescribeBudgetActionHistoriesResponse other = (DescribeBudgetActionHistoriesResponse) obj;
        return hasActionHistories() == other.hasActionHistories() && Objects.equals(actionHistories(), other.actionHistories())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBudgetActionHistoriesResponse")
                .add("ActionHistories", hasActionHistories() ? actionHistories() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionHistories":
            return Optional.ofNullable(clazz.cast(actionHistories()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetActionHistoriesResponse, T> g) {
        return obj -> g.apply((DescribeBudgetActionHistoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBudgetActionHistoriesResponse> {
        /**
         * <p>
         * The historical record of the budget action resource.
         * </p>
         * 
         * @param actionHistories
         *        The historical record of the budget action resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionHistories(Collection<ActionHistory> actionHistories);

        /**
         * <p>
         * The historical record of the budget action resource.
         * </p>
         * 
         * @param actionHistories
         *        The historical record of the budget action resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionHistories(ActionHistory... actionHistories);

        /**
         * <p>
         * The historical record of the budget action resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActionHistory>.Builder} avoiding the need
         * to create one manually via {@link List<ActionHistory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActionHistory>.Builder#build()} is called immediately and
         * its result is passed to {@link #actionHistories(List<ActionHistory>)}.
         * 
         * @param actionHistories
         *        a consumer that will call methods on {@link List<ActionHistory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionHistories(List<ActionHistory>)
         */
        Builder actionHistories(Consumer<ActionHistory.Builder>... actionHistories);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<ActionHistory> actionHistories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetActionHistoriesResponse model) {
            super(model);
            actionHistories(model.actionHistories);
            nextToken(model.nextToken);
        }

        public final Collection<ActionHistory.Builder> getActionHistories() {
            if (actionHistories instanceof SdkAutoConstructList) {
                return null;
            }
            return actionHistories != null ? actionHistories.stream().map(ActionHistory::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder actionHistories(Collection<ActionHistory> actionHistories) {
            this.actionHistories = ActionHistoriesCopier.copy(actionHistories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionHistories(ActionHistory... actionHistories) {
            actionHistories(Arrays.asList(actionHistories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionHistories(Consumer<ActionHistory.Builder>... actionHistories) {
            actionHistories(Stream.of(actionHistories).map(c -> ActionHistory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActionHistories(Collection<ActionHistory.BuilderImpl> actionHistories) {
            this.actionHistories = ActionHistoriesCopier.copyFromBuilder(actionHistories);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetActionHistoriesResponse build() {
            return new DescribeBudgetActionHistoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
