/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service control policies (SCP) action definition details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScpActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ScpActionDefinition.Builder, ScpActionDefinition> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(ScpActionDefinition::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<List<String>> TARGET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetIds")
            .getter(getter(ScpActionDefinition::targetIds))
            .setter(setter(Builder::targetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            TARGET_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final List<String> targetIds;

    private ScpActionDefinition(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.targetIds = builder.targetIds;
    }

    /**
     * <p>
     * The policy ID attached.
     * </p>
     * 
     * @return The policy ID attached.
     */
    public String policyId() {
        return policyId;
    }

    /**
     * Returns true if the TargetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargetIds() {
        return targetIds != null && !(targetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of target IDs.
     */
    public List<String> targetIds() {
        return targetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetIds() ? targetIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScpActionDefinition)) {
            return false;
        }
        ScpActionDefinition other = (ScpActionDefinition) obj;
        return Objects.equals(policyId(), other.policyId()) && hasTargetIds() == other.hasTargetIds()
                && Objects.equals(targetIds(), other.targetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScpActionDefinition").add("PolicyId", policyId())
                .add("TargetIds", hasTargetIds() ? targetIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "TargetIds":
            return Optional.ofNullable(clazz.cast(targetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScpActionDefinition, T> g) {
        return obj -> g.apply((ScpActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScpActionDefinition> {
        /**
         * <p>
         * The policy ID attached.
         * </p>
         * 
         * @param policyId
         *        The policy ID attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * A list of target IDs.
         * </p>
         * 
         * @param targetIds
         *        A list of target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(Collection<String> targetIds);

        /**
         * <p>
         * A list of target IDs.
         * </p>
         * 
         * @param targetIds
         *        A list of target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(String... targetIds);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private List<String> targetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScpActionDefinition model) {
            policyId(model.policyId);
            targetIds(model.targetIds);
        }

        public final String getPolicyId() {
            return policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final Collection<String> getTargetIds() {
            if (targetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return targetIds;
        }

        @Override
        public final Builder targetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIds(String... targetIds) {
            targetIds(Arrays.asList(targetIds));
            return this;
        }

        public final void setTargetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
        }

        @Override
        public ScpActionDefinition build() {
            return new ScpActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
