/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.ActionThreshold;
import software.amazon.awssdk.services.budgets.model.ApprovalModel;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Definition;
import software.amazon.awssdk.services.budgets.model.NotificationType;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBudgetActionRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, UpdateBudgetActionRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::accountId)).setter(UpdateBudgetActionRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::budgetName)).setter(UpdateBudgetActionRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionId").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::actionId)).setter(UpdateBudgetActionRequest.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationType").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::notificationTypeAsString)).setter(UpdateBudgetActionRequest.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final SdkField<ActionThreshold> ACTION_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActionThreshold").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::actionThreshold)).setter(UpdateBudgetActionRequest.setter(Builder::actionThreshold)).constructor(ActionThreshold::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionThreshold").build()}).build();
    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::definition)).setter(UpdateBudgetActionRequest.setter(Builder::definition)).constructor(Definition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::executionRoleArn)).setter(UpdateBudgetActionRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> APPROVAL_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalModel").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::approvalModelAsString)).setter(UpdateBudgetActionRequest.setter(Builder::approvalModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalModel").build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(UpdateBudgetActionRequest.getter(UpdateBudgetActionRequest::subscribers)).setter(UpdateBudgetActionRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, ACTION_ID_FIELD, NOTIFICATION_TYPE_FIELD, ACTION_THRESHOLD_FIELD, DEFINITION_FIELD, EXECUTION_ROLE_ARN_FIELD, APPROVAL_MODEL_FIELD, SUBSCRIBERS_FIELD));
    private final String accountId;
    private final String budgetName;
    private final String actionId;
    private final String notificationType;
    private final ActionThreshold actionThreshold;
    private final Definition definition;
    private final String executionRoleArn;
    private final String approvalModel;
    private final List<Subscriber> subscribers;

    private UpdateBudgetActionRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.actionId = builder.actionId;
        this.notificationType = builder.notificationType;
        this.actionThreshold = builder.actionThreshold;
        this.definition = builder.definition;
        this.executionRoleArn = builder.executionRoleArn;
        this.approvalModel = builder.approvalModel;
        this.subscribers = builder.subscribers;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public String actionId() {
        return this.actionId;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeAsString() {
        return this.notificationType;
    }

    public ActionThreshold actionThreshold() {
        return this.actionThreshold;
    }

    public Definition definition() {
        return this.definition;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public ApprovalModel approvalModel() {
        return ApprovalModel.fromValue(this.approvalModel);
    }

    public String approvalModelAsString() {
        return this.approvalModel;
    }

    public boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetActionRequest)) {
            return false;
        }
        UpdateBudgetActionRequest other = (UpdateBudgetActionRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.actionThreshold(), other.actionThreshold()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.approvalModelAsString(), other.approvalModelAsString()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBudgetActionRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("ActionId", (Object)this.actionId()).add("NotificationType", (Object)this.notificationTypeAsString()).add("ActionThreshold", (Object)this.actionThreshold()).add("Definition", (Object)this.definition()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ApprovalModel", (Object)this.approvalModelAsString()).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
            case "ActionThreshold": {
                return Optional.ofNullable(clazz.cast(this.actionThreshold()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ApprovalModel": {
                return Optional.ofNullable(clazz.cast(this.approvalModelAsString()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetActionRequest, T> g) {
        return obj -> g.apply((UpdateBudgetActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private String actionId;
        private String notificationType;
        private ActionThreshold actionThreshold;
        private Definition definition;
        private String executionRoleArn;
        private String approvalModel;
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetActionRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.actionId(model.actionId);
            this.notificationType(model.notificationType);
            this.actionThreshold(model.actionThreshold);
            this.definition(model.definition);
            this.executionRoleArn(model.executionRoleArn);
            this.approvalModel(model.approvalModel);
            this.subscribers(model.subscribers);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final ActionThreshold.Builder getActionThreshold() {
            return this.actionThreshold != null ? this.actionThreshold.toBuilder() : null;
        }

        @Override
        public final Builder actionThreshold(ActionThreshold actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        public final void setActionThreshold(ActionThreshold.BuilderImpl actionThreshold) {
            this.actionThreshold = actionThreshold != null ? actionThreshold.build() : null;
        }

        public final Definition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getApprovalModel() {
            return this.approvalModel;
        }

        @Override
        public final Builder approvalModel(String approvalModel) {
            this.approvalModel = approvalModel;
            return this;
        }

        @Override
        public final Builder approvalModel(ApprovalModel approvalModel) {
            this.approvalModel(approvalModel == null ? null : approvalModel.toString());
            return this;
        }

        public final void setApprovalModel(String approvalModel) {
            this.approvalModel = approvalModel;
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            if (this.subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscribers != null ? (Collection)this.subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetActionRequest build() {
            return new UpdateBudgetActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBudgetActionRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder actionId(String var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder actionThreshold(ActionThreshold var1);

        default public Builder actionThreshold(Consumer<ActionThreshold.Builder> actionThreshold) {
            return this.actionThreshold((ActionThreshold)((ActionThreshold.Builder)ActionThreshold.builder().applyMutation(actionThreshold)).build());
        }

        public Builder definition(Definition var1);

        default public Builder definition(Consumer<Definition.Builder> definition) {
            return this.definition((Definition)((Definition.Builder)Definition.builder().applyMutation(definition)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder approvalModel(String var1);

        public Builder approvalModel(ApprovalModel var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

