/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The historical records for a budget action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionHistory implements SdkPojo, Serializable, ToCopyableBuilder<ActionHistory.Builder, ActionHistory> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(ActionHistory::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ActionHistory::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(ActionHistory::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<ActionHistoryDetails> ACTION_HISTORY_DETAILS_FIELD = SdkField
            .<ActionHistoryDetails> builder(MarshallingType.SDK_POJO).memberName("ActionHistoryDetails")
            .getter(getter(ActionHistory::actionHistoryDetails)).setter(setter(Builder::actionHistoryDetails))
            .constructor(ActionHistoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionHistoryDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, STATUS_FIELD,
            EVENT_TYPE_FIELD, ACTION_HISTORY_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String status;

    private final String eventType;

    private final ActionHistoryDetails actionHistoryDetails;

    private ActionHistory(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.eventType = builder.eventType;
        this.actionHistoryDetails = builder.actionHistoryDetails;
    }

    /**
     * Returns the value of the Timestamp property for this object.
     * 
     * @return The value of the Timestamp property for this object.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of action at the time of the event.
     * @see ActionStatus
     */
    public final ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of action at the time of the event.
     * @see ActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or generated by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return This distinguishes between whether the events are triggered by the user or generated by the system.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or generated by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return This distinguishes between whether the events are triggered by the user or generated by the system.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The description of details of the event.
     * </p>
     * 
     * @return The description of details of the event.
     */
    public final ActionHistoryDetails actionHistoryDetails() {
        return actionHistoryDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionHistoryDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionHistory)) {
            return false;
        }
        ActionHistory other = (ActionHistory) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(actionHistoryDetails(), other.actionHistoryDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionHistory").add("Timestamp", timestamp()).add("Status", statusAsString())
                .add("EventType", eventTypeAsString()).add("ActionHistoryDetails", actionHistoryDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "ActionHistoryDetails":
            return Optional.ofNullable(clazz.cast(actionHistoryDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionHistory, T> g) {
        return obj -> g.apply((ActionHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionHistory> {
        /**
         * Sets the value of the Timestamp property for this object.
         *
         * @param timestamp
         *        The new value for the Timestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The status of action at the time of the event.
         * </p>
         * 
         * @param status
         *        The status of action at the time of the event.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of action at the time of the event.
         * </p>
         * 
         * @param status
         *        The status of action at the time of the event.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * <p>
         * This distinguishes between whether the events are triggered by the user or generated by the system.
         * </p>
         * 
         * @param eventType
         *        This distinguishes between whether the events are triggered by the user or generated by the system.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * This distinguishes between whether the events are triggered by the user or generated by the system.
         * </p>
         * 
         * @param eventType
         *        This distinguishes between whether the events are triggered by the user or generated by the system.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The description of details of the event.
         * </p>
         * 
         * @param actionHistoryDetails
         *        The description of details of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionHistoryDetails(ActionHistoryDetails actionHistoryDetails);

        /**
         * <p>
         * The description of details of the event.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionHistoryDetails.Builder} avoiding the need
         * to create one manually via {@link ActionHistoryDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionHistoryDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #actionHistoryDetails(ActionHistoryDetails)}.
         * 
         * @param actionHistoryDetails
         *        a consumer that will call methods on {@link ActionHistoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionHistoryDetails(ActionHistoryDetails)
         */
        default Builder actionHistoryDetails(Consumer<ActionHistoryDetails.Builder> actionHistoryDetails) {
            return actionHistoryDetails(ActionHistoryDetails.builder().applyMutation(actionHistoryDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String status;

        private String eventType;

        private ActionHistoryDetails actionHistoryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionHistory model) {
            timestamp(model.timestamp);
            status(model.status);
            eventType(model.eventType);
            actionHistoryDetails(model.actionHistoryDetails);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final ActionHistoryDetails.Builder getActionHistoryDetails() {
            return actionHistoryDetails != null ? actionHistoryDetails.toBuilder() : null;
        }

        @Override
        public final Builder actionHistoryDetails(ActionHistoryDetails actionHistoryDetails) {
            this.actionHistoryDetails = actionHistoryDetails;
            return this;
        }

        public final void setActionHistoryDetails(ActionHistoryDetails.BuilderImpl actionHistoryDetails) {
            this.actionHistoryDetails = actionHistoryDetails != null ? actionHistoryDetails.build() : null;
        }

        @Override
        public ActionHistory build() {
            return new ActionHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
