/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The period of time that is covered by a budget. The period has a start date and an end date. The start date must come
 * before the end date. There are no restrictions on the end date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimePeriod implements SdkPojo, Serializable, ToCopyableBuilder<TimePeriod.Builder, TimePeriod> {
    private static final SdkField<Instant> START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Start")
            .getter(getter(TimePeriod::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("End")
            .getter(getter(TimePeriod::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant start;

    private final Instant end;

    private TimePeriod(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The start date for a budget. If you created your budget and didn't specify a start date, AWS defaults to the
     * start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your
     * budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS set your start date to
     * <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set your start date to
     * <code>01/01/18 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console and
     * the API.
     * </p>
     * <p>
     * You can change your start date with the <code>UpdateBudget</code> operation.
     * </p>
     * 
     * @return The start date for a budget. If you created your budget and didn't specify a start date, AWS defaults to
     *         the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you
     *         created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS set
     *         your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set your start
     *         date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost
     *         Management console and the API.</p>
     *         <p>
     *         You can change your start date with the <code>UpdateBudget</code> operation.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The end date for a budget. If you didn't specify an end date, AWS set your end date to
     * <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console and
     * the API.
     * </p>
     * <p>
     * After the end date, AWS deletes the budget and all associated notifications and subscribers. You can change your
     * end date with the <code>UpdateBudget</code> operation.
     * </p>
     * 
     * @return The end date for a budget. If you didn't specify an end date, AWS set your end date to
     *         <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management
     *         console and the API.</p>
     *         <p>
     *         After the end date, AWS deletes the budget and all associated notifications and subscribers. You can
     *         change your end date with the <code>UpdateBudget</code> operation.
     */
    public final Instant end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimePeriod").add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimePeriod, T> g) {
        return obj -> g.apply((TimePeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimePeriod> {
        /**
         * <p>
         * The start date for a budget. If you created your budget and didn't specify a start date, AWS defaults to the
         * start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your
         * budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS set your start date to
         * <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set your start date to
         * <code>01/01/18 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console
         * and the API.
         * </p>
         * <p>
         * You can change your start date with the <code>UpdateBudget</code> operation.
         * </p>
         * 
         * @param start
         *        The start date for a budget. If you created your budget and didn't specify a start date, AWS defaults
         *        to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you
         *        created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, AWS
         *        set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, AWS set
         *        your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the AWS Billing and
         *        Cost Management console and the API.</p>
         *        <p>
         *        You can change your start date with the <code>UpdateBudget</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end date for a budget. If you didn't specify an end date, AWS set your end date to
         * <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management console
         * and the API.
         * </p>
         * <p>
         * After the end date, AWS deletes the budget and all associated notifications and subscribers. You can change
         * your end date with the <code>UpdateBudget</code> operation.
         * </p>
         * 
         * @param end
         *        The end date for a budget. If you didn't specify an end date, AWS set your end date to
         *        <code>06/15/87 00:00 UTC</code>. The defaults are the same for the AWS Billing and Cost Management
         *        console and the API.</p>
         *        <p>
         *        After the end date, AWS deletes the budget and all associated notifications and subscribers. You can
         *        change your end date with the <code>UpdateBudget</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);
    }

    static final class BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimePeriod model) {
            start(model.start);
            end(model.end);
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public TimePeriod build() {
            return new TimePeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
