/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;

public class DescribeBudgetsIterable
implements SdkIterable<DescribeBudgetsResponse> {
    private final BudgetsClient client;
    private final DescribeBudgetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBudgetsIterable(BudgetsClient client, DescribeBudgetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBudgetsResponseFetcher();
    }

    public Iterator<DescribeBudgetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Budget> budgets() {
        Function<DescribeBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgets() != null) {
                return response.budgets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBudgetsResponseFetcher
    implements SyncPageFetcher<DescribeBudgetsResponse> {
        private DescribeBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBudgetsResponse nextPage(DescribeBudgetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetsIterable.this.client.describeBudgets(DescribeBudgetsIterable.this.firstRequest);
            }
            return DescribeBudgetsIterable.this.client.describeBudgets((DescribeBudgetsRequest)((Object)DescribeBudgetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

