/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Systems Manager (SSM) action definition details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SsmActionDefinition.Builder, SsmActionDefinition> {
    private static final SdkField<String> ACTION_SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionSubType").getter(getter(SsmActionDefinition::actionSubTypeAsString))
            .setter(setter(Builder::actionSubType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionSubType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(SsmActionDefinition::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(SsmActionDefinition::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_SUB_TYPE_FIELD,
            REGION_FIELD, INSTANCE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionSubType;

    private final String region;

    private final List<String> instanceIds;

    private SsmActionDefinition(BuilderImpl builder) {
        this.actionSubType = builder.actionSubType;
        this.region = builder.region;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * The action subType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionSubType}
     * will return {@link ActionSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionSubTypeAsString}.
     * </p>
     * 
     * @return The action subType.
     * @see ActionSubType
     */
    public final ActionSubType actionSubType() {
        return ActionSubType.fromValue(actionSubType);
    }

    /**
     * <p>
     * The action subType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionSubType}
     * will return {@link ActionSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionSubTypeAsString}.
     * </p>
     * 
     * @return The action subType.
     * @see ActionSubType
     */
    public final String actionSubTypeAsString() {
        return actionSubType;
    }

    /**
     * <p>
     * The Region to run the SSM document.
     * </p>
     * 
     * @return The Region to run the SSM document.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 and RDS instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The EC2 and RDS instance IDs.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionSubTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmActionDefinition)) {
            return false;
        }
        SsmActionDefinition other = (SsmActionDefinition) obj;
        return Objects.equals(actionSubTypeAsString(), other.actionSubTypeAsString()) && Objects.equals(region(), other.region())
                && hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SsmActionDefinition").add("ActionSubType", actionSubTypeAsString()).add("Region", region())
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionSubType":
            return Optional.ofNullable(clazz.cast(actionSubTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SsmActionDefinition, T> g) {
        return obj -> g.apply((SsmActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmActionDefinition> {
        /**
         * <p>
         * The action subType.
         * </p>
         * 
         * @param actionSubType
         *        The action subType.
         * @see ActionSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionSubType
         */
        Builder actionSubType(String actionSubType);

        /**
         * <p>
         * The action subType.
         * </p>
         * 
         * @param actionSubType
         *        The action subType.
         * @see ActionSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionSubType
         */
        Builder actionSubType(ActionSubType actionSubType);

        /**
         * <p>
         * The Region to run the SSM document.
         * </p>
         * 
         * @param region
         *        The Region to run the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The EC2 and RDS instance IDs.
         * </p>
         * 
         * @param instanceIds
         *        The EC2 and RDS instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The EC2 and RDS instance IDs.
         * </p>
         * 
         * @param instanceIds
         *        The EC2 and RDS instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);
    }

    static final class BuilderImpl implements Builder {
        private String actionSubType;

        private String region;

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SsmActionDefinition model) {
            actionSubType(model.actionSubType);
            region(model.region);
            instanceIds(model.instanceIds);
        }

        public final String getActionSubType() {
            return actionSubType;
        }

        public final void setActionSubType(String actionSubType) {
            this.actionSubType = actionSubType;
        }

        @Override
        @Transient
        public final Builder actionSubType(String actionSubType) {
            this.actionSubType = actionSubType;
            return this;
        }

        @Override
        @Transient
        public final Builder actionSubType(ActionSubType actionSubType) {
            this.actionSubType(actionSubType == null ? null : actionSubType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        @Override
        @Transient
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        public SsmActionDefinition build() {
            return new SsmActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
