/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request of UpdateSubscriber
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriberRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateSubscriberRequest.Builder, UpdateSubscriberRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdateSubscriberRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(UpdateSubscriberRequest::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .memberName("Notification").getter(getter(UpdateSubscriberRequest::notification))
            .setter(setter(Builder::notification)).constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<Subscriber> OLD_SUBSCRIBER_FIELD = SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
            .memberName("OldSubscriber").getter(getter(UpdateSubscriberRequest::oldSubscriber))
            .setter(setter(Builder::oldSubscriber)).constructor(Subscriber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldSubscriber").build()).build();

    private static final SdkField<Subscriber> NEW_SUBSCRIBER_FIELD = SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
            .memberName("NewSubscriber").getter(getter(UpdateSubscriberRequest::newSubscriber))
            .setter(setter(Builder::newSubscriber)).constructor(Subscriber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSubscriber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, NOTIFICATION_FIELD, OLD_SUBSCRIBER_FIELD, NEW_SUBSCRIBER_FIELD));

    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final Subscriber oldSubscriber;

    private final Subscriber newSubscriber;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.oldSubscriber = builder.oldSubscriber;
        this.newSubscriber = builder.newSubscriber;
    }

    /**
     * <p>
     * The <code>accountId</code> that is associated with the budget whose subscriber you want to update.
     * </p>
     * 
     * @return The <code>accountId</code> that is associated with the budget whose subscriber you want to update.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the budget whose subscriber you want to update.
     * </p>
     * 
     * @return The name of the budget whose subscriber you want to update.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * The notification whose subscriber you want to update.
     * </p>
     * 
     * @return The notification whose subscriber you want to update.
     */
    public final Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The previous subscriber that is associated with a budget notification.
     * </p>
     * 
     * @return The previous subscriber that is associated with a budget notification.
     */
    public final Subscriber oldSubscriber() {
        return oldSubscriber;
    }

    /**
     * <p>
     * The updated subscriber that is associated with a budget notification.
     * </p>
     * 
     * @return The updated subscriber that is associated with a budget notification.
     */
    public final Subscriber newSubscriber() {
        return newSubscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(oldSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(newSubscriber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(notification(), other.notification()) && Objects.equals(oldSubscriber(), other.oldSubscriber())
                && Objects.equals(newSubscriber(), other.newSubscriber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriberRequest").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("Notification", notification()).add("OldSubscriber", oldSubscriber()).add("NewSubscriber", newSubscriber())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "OldSubscriber":
            return Optional.ofNullable(clazz.cast(oldSubscriber()));
        case "NewSubscriber":
            return Optional.ofNullable(clazz.cast(newSubscriber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberRequest, T> g) {
        return obj -> g.apply((UpdateSubscriberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSubscriberRequest> {
        /**
         * <p>
         * The <code>accountId</code> that is associated with the budget whose subscriber you want to update.
         * </p>
         * 
         * @param accountId
         *        The <code>accountId</code> that is associated with the budget whose subscriber you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the budget whose subscriber you want to update.
         * </p>
         * 
         * @param budgetName
         *        The name of the budget whose subscriber you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * The notification whose subscriber you want to update.
         * </p>
         * 
         * @param notification
         *        The notification whose subscriber you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The notification whose subscriber you want to update.
         * </p>
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The previous subscriber that is associated with a budget notification.
         * </p>
         * 
         * @param oldSubscriber
         *        The previous subscriber that is associated with a budget notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldSubscriber(Subscriber oldSubscriber);

        /**
         * <p>
         * The previous subscriber that is associated with a budget notification.
         * </p>
         * This is a convenience that creates an instance of the {@link Subscriber.Builder} avoiding the need to create
         * one manually via {@link Subscriber#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subscriber.Builder#build()} is called immediately and its result
         * is passed to {@link #oldSubscriber(Subscriber)}.
         * 
         * @param oldSubscriber
         *        a consumer that will call methods on {@link Subscriber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oldSubscriber(Subscriber)
         */
        default Builder oldSubscriber(Consumer<Subscriber.Builder> oldSubscriber) {
            return oldSubscriber(Subscriber.builder().applyMutation(oldSubscriber).build());
        }

        /**
         * <p>
         * The updated subscriber that is associated with a budget notification.
         * </p>
         * 
         * @param newSubscriber
         *        The updated subscriber that is associated with a budget notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newSubscriber(Subscriber newSubscriber);

        /**
         * <p>
         * The updated subscriber that is associated with a budget notification.
         * </p>
         * This is a convenience that creates an instance of the {@link Subscriber.Builder} avoiding the need to create
         * one manually via {@link Subscriber#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subscriber.Builder#build()} is called immediately and its result
         * is passed to {@link #newSubscriber(Subscriber)}.
         * 
         * @param newSubscriber
         *        a consumer that will call methods on {@link Subscriber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newSubscriber(Subscriber)
         */
        default Builder newSubscriber(Consumer<Subscriber.Builder> newSubscriber) {
            return newSubscriber(Subscriber.builder().applyMutation(newSubscriber).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private Subscriber oldSubscriber;

        private Subscriber newSubscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            notification(model.notification);
            oldSubscriber(model.oldSubscriber);
            newSubscriber(model.newSubscriber);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        @Transient
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        @Transient
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final Subscriber.Builder getOldSubscriber() {
            return oldSubscriber != null ? oldSubscriber.toBuilder() : null;
        }

        public final void setOldSubscriber(Subscriber.BuilderImpl oldSubscriber) {
            this.oldSubscriber = oldSubscriber != null ? oldSubscriber.build() : null;
        }

        @Override
        @Transient
        public final Builder oldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
            return this;
        }

        public final Subscriber.Builder getNewSubscriber() {
            return newSubscriber != null ? newSubscriber.toBuilder() : null;
        }

        public final void setNewSubscriber(Subscriber.BuilderImpl newSubscriber) {
            this.newSubscriber = newSubscriber != null ? newSubscriber.build() : null;
        }

        @Override
        @Transient
        public final Builder newSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
