/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BudgetNotificationsForAccountListCopier {
    static List<BudgetNotificationsForAccount> copy(
            Collection<? extends BudgetNotificationsForAccount> budgetNotificationsForAccountListParam) {
        List<BudgetNotificationsForAccount> list;
        if (budgetNotificationsForAccountListParam == null
                || budgetNotificationsForAccountListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BudgetNotificationsForAccount> modifiableList = new ArrayList<>();
            budgetNotificationsForAccountListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BudgetNotificationsForAccount> copyFromBuilder(
            Collection<? extends BudgetNotificationsForAccount.Builder> budgetNotificationsForAccountListParam) {
        List<BudgetNotificationsForAccount> list;
        if (budgetNotificationsForAccountListParam == null
                || budgetNotificationsForAccountListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BudgetNotificationsForAccount> modifiableList = new ArrayList<>();
            budgetNotificationsForAccountListParam.forEach(entry -> {
                BudgetNotificationsForAccount member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BudgetNotificationsForAccount.Builder> copyToBuilder(
            Collection<? extends BudgetNotificationsForAccount> budgetNotificationsForAccountListParam) {
        List<BudgetNotificationsForAccount.Builder> list;
        if (budgetNotificationsForAccountListParam == null
                || budgetNotificationsForAccountListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BudgetNotificationsForAccount.Builder> modifiableList = new ArrayList<>();
            budgetNotificationsForAccountListParam.forEach(entry -> {
                BudgetNotificationsForAccount.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
