/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of cost or usage that you created the budget for, compared to your actual costs or usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetedAndActualAmounts implements SdkPojo, Serializable,
        ToCopyableBuilder<BudgetedAndActualAmounts.Builder, BudgetedAndActualAmounts> {
    private static final SdkField<Spend> BUDGETED_AMOUNT_FIELD = SdkField.<Spend> builder(MarshallingType.SDK_POJO)
            .memberName("BudgetedAmount").getter(getter(BudgetedAndActualAmounts::budgetedAmount))
            .setter(setter(Builder::budgetedAmount)).constructor(Spend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetedAmount").build()).build();

    private static final SdkField<Spend> ACTUAL_AMOUNT_FIELD = SdkField.<Spend> builder(MarshallingType.SDK_POJO)
            .memberName("ActualAmount").getter(getter(BudgetedAndActualAmounts::actualAmount))
            .setter(setter(Builder::actualAmount)).constructor(Spend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualAmount").build()).build();

    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.<TimePeriod> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(BudgetedAndActualAmounts::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(TimePeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGETED_AMOUNT_FIELD,
            ACTUAL_AMOUNT_FIELD, TIME_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Spend budgetedAmount;

    private final Spend actualAmount;

    private final TimePeriod timePeriod;

    private BudgetedAndActualAmounts(BuilderImpl builder) {
        this.budgetedAmount = builder.budgetedAmount;
        this.actualAmount = builder.actualAmount;
        this.timePeriod = builder.timePeriod;
    }

    /**
     * <p>
     * The amount of cost or usage that you created the budget for.
     * </p>
     * 
     * @return The amount of cost or usage that you created the budget for.
     */
    public final Spend budgetedAmount() {
        return budgetedAmount;
    }

    /**
     * <p>
     * Your actual costs or usage for a budget period.
     * </p>
     * 
     * @return Your actual costs or usage for a budget period.
     */
    public final Spend actualAmount() {
        return actualAmount;
    }

    /**
     * <p>
     * The time period that's covered by this budget comparison.
     * </p>
     * 
     * @return The time period that's covered by this budget comparison.
     */
    public final TimePeriod timePeriod() {
        return timePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budgetedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(actualAmount());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetedAndActualAmounts)) {
            return false;
        }
        BudgetedAndActualAmounts other = (BudgetedAndActualAmounts) obj;
        return Objects.equals(budgetedAmount(), other.budgetedAmount()) && Objects.equals(actualAmount(), other.actualAmount())
                && Objects.equals(timePeriod(), other.timePeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetedAndActualAmounts").add("BudgetedAmount", budgetedAmount())
                .add("ActualAmount", actualAmount()).add("TimePeriod", timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetedAmount":
            return Optional.ofNullable(clazz.cast(budgetedAmount()));
        case "ActualAmount":
            return Optional.ofNullable(clazz.cast(actualAmount()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetedAndActualAmounts, T> g) {
        return obj -> g.apply((BudgetedAndActualAmounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetedAndActualAmounts> {
        /**
         * <p>
         * The amount of cost or usage that you created the budget for.
         * </p>
         * 
         * @param budgetedAmount
         *        The amount of cost or usage that you created the budget for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetedAmount(Spend budgetedAmount);

        /**
         * <p>
         * The amount of cost or usage that you created the budget for.
         * </p>
         * This is a convenience method that creates an instance of the {@link Spend.Builder} avoiding the need to
         * create one manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #budgetedAmount(Spend)}.
         * 
         * @param budgetedAmount
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetedAmount(Spend)
         */
        default Builder budgetedAmount(Consumer<Spend.Builder> budgetedAmount) {
            return budgetedAmount(Spend.builder().applyMutation(budgetedAmount).build());
        }

        /**
         * <p>
         * Your actual costs or usage for a budget period.
         * </p>
         * 
         * @param actualAmount
         *        Your actual costs or usage for a budget period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualAmount(Spend actualAmount);

        /**
         * <p>
         * Your actual costs or usage for a budget period.
         * </p>
         * This is a convenience method that creates an instance of the {@link Spend.Builder} avoiding the need to
         * create one manually via {@link Spend#builder()}.
         *
         * When the {@link Consumer} completes, {@link Spend.Builder#build()} is called immediately and its result is
         * passed to {@link #actualAmount(Spend)}.
         * 
         * @param actualAmount
         *        a consumer that will call methods on {@link Spend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualAmount(Spend)
         */
        default Builder actualAmount(Consumer<Spend.Builder> actualAmount) {
            return actualAmount(Spend.builder().applyMutation(actualAmount).build());
        }

        /**
         * <p>
         * The time period that's covered by this budget comparison.
         * </p>
         * 
         * @param timePeriod
         *        The time period that's covered by this budget comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(TimePeriod timePeriod);

        /**
         * <p>
         * The time period that's covered by this budget comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimePeriod.Builder} avoiding the need to
         * create one manually via {@link TimePeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimePeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #timePeriod(TimePeriod)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link TimePeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(TimePeriod)
         */
        default Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return timePeriod(TimePeriod.builder().applyMutation(timePeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Spend budgetedAmount;

        private Spend actualAmount;

        private TimePeriod timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetedAndActualAmounts model) {
            budgetedAmount(model.budgetedAmount);
            actualAmount(model.actualAmount);
            timePeriod(model.timePeriod);
        }

        public final Spend.Builder getBudgetedAmount() {
            return budgetedAmount != null ? budgetedAmount.toBuilder() : null;
        }

        public final void setBudgetedAmount(Spend.BuilderImpl budgetedAmount) {
            this.budgetedAmount = budgetedAmount != null ? budgetedAmount.build() : null;
        }

        @Override
        @Transient
        public final Builder budgetedAmount(Spend budgetedAmount) {
            this.budgetedAmount = budgetedAmount;
            return this;
        }

        public final Spend.Builder getActualAmount() {
            return actualAmount != null ? actualAmount.toBuilder() : null;
        }

        public final void setActualAmount(Spend.BuilderImpl actualAmount) {
            this.actualAmount = actualAmount != null ? actualAmount.build() : null;
        }

        @Override
        @Transient
        public final Builder actualAmount(Spend actualAmount) {
            this.actualAmount = actualAmount;
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        @Override
        public BudgetedAndActualAmounts build() {
            return new BudgetedAndActualAmounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
