/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request of CreateBudget
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBudgetRequest extends BudgetsRequest implements
        ToCopyableBuilder<CreateBudgetRequest.Builder, CreateBudgetRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CreateBudgetRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Budget> BUDGET_FIELD = SdkField.<Budget> builder(MarshallingType.SDK_POJO).memberName("Budget")
            .getter(getter(CreateBudgetRequest::budget)).setter(setter(Builder::budget)).constructor(Budget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budget").build()).build();

    private static final SdkField<List<NotificationWithSubscribers>> NOTIFICATIONS_WITH_SUBSCRIBERS_FIELD = SdkField
            .<List<NotificationWithSubscribers>> builder(MarshallingType.LIST)
            .memberName("NotificationsWithSubscribers")
            .getter(getter(CreateBudgetRequest::notificationsWithSubscribers))
            .setter(setter(Builder::notificationsWithSubscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsWithSubscribers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationWithSubscribers> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationWithSubscribers::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_FIELD, NOTIFICATIONS_WITH_SUBSCRIBERS_FIELD));

    private final String accountId;

    private final Budget budget;

    private final List<NotificationWithSubscribers> notificationsWithSubscribers;

    private CreateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budget = builder.budget;
        this.notificationsWithSubscribers = builder.notificationsWithSubscribers;
    }

    /**
     * <p>
     * The <code>accountId</code> that is associated with the budget.
     * </p>
     * 
     * @return The <code>accountId</code> that is associated with the budget.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The budget object that you want to create.
     * </p>
     * 
     * @return The budget object that you want to create.
     */
    public final Budget budget() {
        return budget;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationsWithSubscribers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotificationsWithSubscribers() {
        return notificationsWithSubscribers != null && !(notificationsWithSubscribers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A notification that you want to associate with a budget. A budget can have up to five notifications, and each
     * notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and
     * subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and subscribers
     * for you.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationsWithSubscribers} method.
     * </p>
     * 
     * @return A notification that you want to associate with a budget. A budget can have up to five notifications, and
     *         each notification can have one SNS subscriber and up to 10 email subscribers. If you include
     *         notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the
     *         notifications and subscribers for you.
     */
    public final List<NotificationWithSubscribers> notificationsWithSubscribers() {
        return notificationsWithSubscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budget());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationsWithSubscribers() ? notificationsWithSubscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budget(), other.budget())
                && hasNotificationsWithSubscribers() == other.hasNotificationsWithSubscribers()
                && Objects.equals(notificationsWithSubscribers(), other.notificationsWithSubscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBudgetRequest").add("AccountId", accountId()).add("Budget", budget())
                .add("NotificationsWithSubscribers", hasNotificationsWithSubscribers() ? notificationsWithSubscribers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Budget":
            return Optional.ofNullable(clazz.cast(budget()));
        case "NotificationsWithSubscribers":
            return Optional.ofNullable(clazz.cast(notificationsWithSubscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBudgetRequest, T> g) {
        return obj -> g.apply((CreateBudgetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBudgetRequest> {
        /**
         * <p>
         * The <code>accountId</code> that is associated with the budget.
         * </p>
         * 
         * @param accountId
         *        The <code>accountId</code> that is associated with the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The budget object that you want to create.
         * </p>
         * 
         * @param budget
         *        The budget object that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);

        /**
         * <p>
         * The budget object that you want to create.
         * </p>
         * This is a convenience method that creates an instance of the {@link Budget.Builder} avoiding the need to
         * create one manually via {@link Budget#builder()}.
         *
         * When the {@link Consumer} completes, {@link Budget.Builder#build()} is called immediately and its result is
         * passed to {@link #budget(Budget)}.
         * 
         * @param budget
         *        a consumer that will call methods on {@link Budget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budget(Budget)
         */
        default Builder budget(Consumer<Budget.Builder> budget) {
            return budget(Budget.builder().applyMutation(budget).build());
        }

        /**
         * <p>
         * A notification that you want to associate with a budget. A budget can have up to five notifications, and each
         * notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and
         * subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and
         * subscribers for you.
         * </p>
         * 
         * @param notificationsWithSubscribers
         *        A notification that you want to associate with a budget. A budget can have up to five notifications,
         *        and each notification can have one SNS subscriber and up to 10 email subscribers. If you include
         *        notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the
         *        notifications and subscribers for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers);

        /**
         * <p>
         * A notification that you want to associate with a budget. A budget can have up to five notifications, and each
         * notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and
         * subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and
         * subscribers for you.
         * </p>
         * 
         * @param notificationsWithSubscribers
         *        A notification that you want to associate with a budget. A budget can have up to five notifications,
         *        and each notification can have one SNS subscriber and up to 10 email subscribers. If you include
         *        notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the
         *        notifications and subscribers for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsWithSubscribers(NotificationWithSubscribers... notificationsWithSubscribers);

        /**
         * <p>
         * A notification that you want to associate with a budget. A budget can have up to five notifications, and each
         * notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and
         * subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and
         * subscribers for you.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <NotificationWithSubscribers>.Builder} avoiding the need to create one manually via {@link List
         * <NotificationWithSubscribers>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotificationWithSubscribers>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #notificationsWithSubscribers(List<NotificationWithSubscribers>)}.
         * 
         * @param notificationsWithSubscribers
         *        a consumer that will call methods on {@link List<NotificationWithSubscribers>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsWithSubscribers(List<NotificationWithSubscribers>)
         */
        Builder notificationsWithSubscribers(Consumer<NotificationWithSubscribers.Builder>... notificationsWithSubscribers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private Budget budget;

        private List<NotificationWithSubscribers> notificationsWithSubscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            super(model);
            accountId(model.accountId);
            budget(model.budget);
            notificationsWithSubscribers(model.notificationsWithSubscribers);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Budget.Builder getBudget() {
            return budget != null ? budget.toBuilder() : null;
        }

        public final void setBudget(Budget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        @Transient
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final List<NotificationWithSubscribers.Builder> getNotificationsWithSubscribers() {
            List<NotificationWithSubscribers.Builder> result = NotificationWithSubscribersListCopier
                    .copyToBuilder(this.notificationsWithSubscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationsWithSubscribers(
                Collection<NotificationWithSubscribers.BuilderImpl> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier
                    .copyFromBuilder(notificationsWithSubscribers);
        }

        @Override
        @Transient
        public final Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationsWithSubscribers(NotificationWithSubscribers... notificationsWithSubscribers) {
            notificationsWithSubscribers(Arrays.asList(notificationsWithSubscribers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationsWithSubscribers(
                Consumer<NotificationWithSubscribers.Builder>... notificationsWithSubscribers) {
            notificationsWithSubscribers(Stream.of(notificationsWithSubscribers)
                    .map(c -> NotificationWithSubscribers.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
