/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response of DescribeBudget
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBudgetResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeBudgetResponse.Builder, DescribeBudgetResponse> {
    private static final SdkField<Budget> BUDGET_FIELD = SdkField.<Budget> builder(MarshallingType.SDK_POJO).memberName("Budget")
            .getter(getter(DescribeBudgetResponse::budget)).setter(setter(Builder::budget)).constructor(Budget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_FIELD));

    private final Budget budget;

    private DescribeBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.budget = builder.budget;
    }

    /**
     * <p>
     * The description of the budget.
     * </p>
     * 
     * @return The description of the budget.
     */
    public final Budget budget() {
        return budget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(budget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetResponse)) {
            return false;
        }
        DescribeBudgetResponse other = (DescribeBudgetResponse) obj;
        return Objects.equals(budget(), other.budget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBudgetResponse").add("Budget", budget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Budget":
            return Optional.ofNullable(clazz.cast(budget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetResponse, T> g) {
        return obj -> g.apply((DescribeBudgetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBudgetResponse> {
        /**
         * <p>
         * The description of the budget.
         * </p>
         * 
         * @param budget
         *        The description of the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);

        /**
         * <p>
         * The description of the budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link Budget.Builder} avoiding the need to
         * create one manually via {@link Budget#builder()}.
         *
         * When the {@link Consumer} completes, {@link Budget.Builder#build()} is called immediately and its result is
         * passed to {@link #budget(Budget)}.
         * 
         * @param budget
         *        a consumer that will call methods on {@link Budget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budget(Budget)
         */
        default Builder budget(Consumer<Budget.Builder> budget) {
            return budget(Budget.builder().applyMutation(budget).build());
        }
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private Budget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetResponse model) {
            super(model);
            budget(model.budget);
        }

        public final Budget.Builder getBudget() {
            return budget != null ? budget.toBuilder() : null;
        }

        public final void setBudget(Budget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        @Transient
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        @Override
        public DescribeBudgetResponse build() {
            return new DescribeBudgetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
